/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.internal;

import de.rcenvironment.core.component.execution.api.ComponentState;
import de.rcenvironment.core.component.workflow.execution.internal.ComponentStatesChangedEntirelyListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ComponentStatesChangedEntirelyVerifier {
    private Set<ComponentStatesChangedEntirelyListener> compStatesEntirelyChangedListeners = new HashSet<ComponentStatesChangedEntirelyListener>();
    private final ComponentStatesChangedEntirelyNotifier preparedComponentStateNotifier;
    private final ComponentStatesChangedEntirelyNotifier pausedComponentStateNotifier;
    private final ComponentStatesChangedEntirelyNotifier resumedComponentStateNotifier;
    private final ComponentStatesChangedEntirelyNotifier finishedComponentStateNotifier;
    private final ComponentStatesChangedEntirelyNotifier finalComponentStateNotifier;
    private final ComponentStatesChangedEntirelyNotifier disposedComponentStateNotifier;
    private final Set<String> lostComponents;
    private final ComponentStatesChangedEntirelyNotifier lastConsoleRowNotifier;

    protected ComponentStatesChangedEntirelyVerifier(int componentCount) {
        this.preparedComponentStateNotifier = new PreparedComponentStateNotifier(componentCount);
        this.pausedComponentStateNotifier = new PausedComponentStateNotifier(componentCount);
        this.resumedComponentStateNotifier = new ResumedComponentStateNotifier(componentCount);
        this.finishedComponentStateNotifier = new FinishedComponentStateNotifier(componentCount);
        this.finalComponentStateNotifier = new FinalComponentStateNotifier(componentCount);
        this.disposedComponentStateNotifier = new DisposedComponentStateNotifier(componentCount);
        this.lostComponents = new HashSet<String>();
        this.lastConsoleRowNotifier = new LastConsoleRowNotifier(componentCount);
    }

    public void addListener(ComponentStatesChangedEntirelyListener listener) {
        this.compStatesEntirelyChangedListeners.add(listener);
    }

    public void announceComponentState(String compExecutionId, ComponentState compState) {
        switch (compState) {
            case PREPARED: {
                this.preparedComponentStateNotifier.addComponentInDesiredState(compExecutionId);
                break;
            }
            case PAUSED: {
                if (!this.pausedComponentStateNotifier.isEnabled()) break;
                this.pausedComponentStateNotifier.addComponentInDesiredState(compExecutionId);
                break;
            }
            case FINISHED: 
            case FINISHED_WITHOUT_EXECUTION: {
                this.finishedComponentStateNotifier.addComponentInDesiredState(compExecutionId);
            }
            case FAILED: 
            case CANCELED: 
            case RESULTS_REJECTED: {
                this.finalComponentStateNotifier.addComponentInDesiredState(compExecutionId);
                if (!this.pausedComponentStateNotifier.isEnabled()) break;
                this.pausedComponentStateNotifier.addComponentInDesiredState(compExecutionId);
                break;
            }
            case DISPOSED: {
                this.disposedComponentStateNotifier.addComponentInDesiredState(compExecutionId);
                break;
            }
        }
        if (this.resumedComponentStateNotifier.isEnabled() && !ComponentState.RESUMING.equals((Object)compState)) {
            this.resumedComponentStateNotifier.addComponentInDesiredState(compExecutionId);
        }
    }

    public void accounceComponentInAnyFinalState(String compExecutionId) {
        this.finalComponentStateNotifier.addComponentInDesiredState(compExecutionId);
    }

    public void announceLastConsoleRow(String compExecutionId) {
        this.lastConsoleRowNotifier.addComponentInDesiredState(compExecutionId);
    }

    public void announceLostComponents(Set<String> compExecutionIds) {
        for (ComponentStatesChangedEntirelyListener compStatesEntirelyChangedListener : this.compStatesEntirelyChangedListeners) {
            compStatesEntirelyChangedListener.onComponentsLost(compExecutionIds);
        }
        this.lostComponents.addAll(compExecutionIds);
    }

    public void declareLostComponentsAsBeingInFinalStateAndDisposed() {
        this.finalComponentStateNotifier.addComponentsInDesiredState(this.lostComponents);
        this.disposedComponentStateNotifier.addComponentsInDesiredState(this.lostComponents);
        this.lastConsoleRowNotifier.addComponentsInDesiredState(this.lostComponents);
    }

    public boolean isComponentInFinalState(String compExecutionId) {
        return this.finalComponentStateNotifier.isComponentInDesiredState(compExecutionId);
    }

    public boolean isComponentDisposed(String compExecutionId) {
        return this.disposedComponentStateNotifier.isComponentInDesiredState(compExecutionId);
    }

    public Set<String> getLostComponents() {
        return Collections.unmodifiableSet(this.lostComponents);
    }

    public Set<String> getComponentsInFinalState() {
        return this.finalComponentStateNotifier.getComponentsInDesiredState();
    }

    public Set<String> getDisposedComponents() {
        return this.disposedComponentStateNotifier.getComponentsInDesiredState();
    }

    public void enablePausedComponentStateVerification() {
        this.pausedComponentStateNotifier.clearComponentsInDesiredState();
        this.pausedComponentStateNotifier.setEnabled(true);
        this.pausedComponentStateNotifier.addComponentsInDesiredState(this.finalComponentStateNotifier.getComponentsInDesiredState());
    }

    public void enableResumedComponentStateVerification() {
        this.resumedComponentStateNotifier.clearComponentsInDesiredState();
        this.resumedComponentStateNotifier.setEnabled(true);
        this.resumedComponentStateNotifier.addComponentsInDesiredState(this.finalComponentStateNotifier.getComponentsInDesiredState());
    }

    private abstract class ComponentStatesChangedEntirelyNotifier {
        private final int compCount;
        private boolean enabled = false;
        private Set<String> componentsInDesiredState = Collections.synchronizedSet(new HashSet<String>(){
            private static final long serialVersionUID = 6431615134151724870L;

            @Override
            public boolean add(String e) {
                boolean rv = super.add(e);
                if (this.size() == ComponentStatesChangedEntirelyNotifier.this.compCount) {
                    ComponentStatesChangedEntirelyNotifier.this.onComponentStatesChangedEntirely();
                }
                return rv;
            }
        });

        private ComponentStatesChangedEntirelyNotifier(int componentCount, boolean enabled) {
            this.compCount = componentCount;
            this.enabled = enabled;
        }

        private synchronized void clearComponentsInDesiredState() {
            this.componentsInDesiredState.clear();
        }

        private synchronized void addComponentInDesiredState(String executionIdentifier) {
            if (this.enabled) {
                this.componentsInDesiredState.add(executionIdentifier);
            }
        }

        private synchronized void addComponentsInDesiredState(Set<String> executionIdentifiers) {
            if (this.enabled) {
                this.componentsInDesiredState.addAll(executionIdentifiers);
            }
        }

        private synchronized Set<String> getComponentsInDesiredState() {
            return Collections.unmodifiableSet(this.componentsInDesiredState);
        }

        private synchronized boolean isComponentInDesiredState(String executionIdentifier) {
            return this.componentsInDesiredState.contains(executionIdentifier);
        }

        protected synchronized void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        private synchronized boolean isEnabled() {
            return this.enabled;
        }

        abstract void onComponentStatesChangedEntirely();
    }

    private final class DisposedComponentStateNotifier
    extends ComponentStatesChangedEntirelyNotifier {
        private DisposedComponentStateNotifier(int componentCount) {
            super(componentCount, true);
        }

        @Override
        protected void onComponentStatesChangedEntirely() {
            for (ComponentStatesChangedEntirelyListener compStatesEntirelyChangedListener : ComponentStatesChangedEntirelyVerifier.this.compStatesEntirelyChangedListeners) {
                compStatesEntirelyChangedListener.onComponentStatesChangedCompletelyToDisposed();
            }
        }
    }

    private final class FinalComponentStateNotifier
    extends ComponentStatesChangedEntirelyNotifier {
        private FinalComponentStateNotifier(int componentCount) {
            super(componentCount, true);
        }

        @Override
        protected void onComponentStatesChangedEntirely() {
            for (ComponentStatesChangedEntirelyListener compStatesEntirelyChangedListener : ComponentStatesChangedEntirelyVerifier.this.compStatesEntirelyChangedListeners) {
                compStatesEntirelyChangedListener.onComponentStatesChangedCompletelyToAnyFinalState();
            }
        }
    }

    private final class FinishedComponentStateNotifier
    extends ComponentStatesChangedEntirelyNotifier {
        private FinishedComponentStateNotifier(int componentCount) {
            super(componentCount, true);
        }

        @Override
        protected void onComponentStatesChangedEntirely() {
            for (ComponentStatesChangedEntirelyListener compStatesEntirelyChangedListener : ComponentStatesChangedEntirelyVerifier.this.compStatesEntirelyChangedListeners) {
                compStatesEntirelyChangedListener.onComponentStatesChangedCompletelyToFinished();
            }
        }
    }

    private final class LastConsoleRowNotifier
    extends ComponentStatesChangedEntirelyNotifier {
        private LastConsoleRowNotifier(int componentCount) {
            super(componentCount, true);
        }

        @Override
        protected void onComponentStatesChangedEntirely() {
            for (ComponentStatesChangedEntirelyListener compStatesEntirelyChangedListener : ComponentStatesChangedEntirelyVerifier.this.compStatesEntirelyChangedListeners) {
                compStatesEntirelyChangedListener.onLastConsoleRowsReceived();
            }
        }
    }

    private final class PausedComponentStateNotifier
    extends ComponentStatesChangedEntirelyNotifier {
        private PausedComponentStateNotifier(int componentCount) {
            super(componentCount, false);
        }

        @Override
        protected void onComponentStatesChangedEntirely() {
            for (ComponentStatesChangedEntirelyListener compStatesEntirelyChangedListener : ComponentStatesChangedEntirelyVerifier.this.compStatesEntirelyChangedListeners) {
                compStatesEntirelyChangedListener.onComponentStatesChangedCompletelyToPaused();
            }
            this.setEnabled(false);
        }
    }

    private final class PreparedComponentStateNotifier
    extends ComponentStatesChangedEntirelyNotifier {
        private PreparedComponentStateNotifier(int componentCount) {
            super(componentCount, true);
        }

        @Override
        protected void onComponentStatesChangedEntirely() {
            for (ComponentStatesChangedEntirelyListener compStatesEntirelyChangedListener : ComponentStatesChangedEntirelyVerifier.this.compStatesEntirelyChangedListeners) {
                compStatesEntirelyChangedListener.onComponentStatesChangedCompletelyToPrepared();
            }
        }
    }

    private final class ResumedComponentStateNotifier
    extends ComponentStatesChangedEntirelyNotifier {
        private ResumedComponentStateNotifier(int componentCount) {
            super(componentCount, false);
        }

        @Override
        protected void onComponentStatesChangedEntirely() {
            for (ComponentStatesChangedEntirelyListener compStatesEntirelyChangedListener : ComponentStatesChangedEntirelyVerifier.this.compStatesEntirelyChangedListeners) {
                compStatesEntirelyChangedListener.onComponentStatesChangedCompletelyToResumed();
            }
            this.setEnabled(false);
        }
    }
}

