/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.connection.impl;

import de.rcenvironment.core.communication.channel.MessageChannelLifecycleListener;
import de.rcenvironment.core.communication.channel.MessageChannelLifecycleListenerAdapter;
import de.rcenvironment.core.communication.channel.MessageChannelService;
import de.rcenvironment.core.communication.connection.api.ConnectionSetup;
import de.rcenvironment.core.communication.connection.api.ConnectionSetupListener;
import de.rcenvironment.core.communication.connection.api.ConnectionSetupListenerAdapter;
import de.rcenvironment.core.communication.connection.api.ConnectionSetupService;
import de.rcenvironment.core.communication.connection.api.ConnectionSetupState;
import de.rcenvironment.core.communication.connection.api.DisconnectReason;
import de.rcenvironment.core.communication.connection.impl.ConnectionSetupImpl;
import de.rcenvironment.core.communication.model.NetworkContactPoint;
import de.rcenvironment.core.communication.transport.spi.MessageChannel;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.service.AdditionalServiceDeclaration;
import de.rcenvironment.core.utils.common.service.AdditionalServicesProvider;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallback;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallbackExceptionPolicy;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncOrderedCallbackManager;
import de.rcenvironment.toolkit.utils.common.ConsistencyChecks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionSetupServiceImpl
implements ConnectionSetupService,
AdditionalServicesProvider {
    private MessageChannelService messageChannelService;
    private final List<ConnectionSetup> setups = new ArrayList<ConnectionSetup>();
    private final AtomicLong lastSetupId = new AtomicLong();
    private final AsyncOrderedCallbackManager<ConnectionSetupListener> callbackManager = ConcurrencyUtils.getFactory().createAsyncOrderedCallbackManager(AsyncCallbackExceptionPolicy.LOG_AND_CANCEL_LISTENER);
    private final Log log = LogFactory.getLog(this.getClass());

    public Collection<AdditionalServiceDeclaration> defineAdditionalServices() {
        ArrayList<AdditionalServiceDeclaration> result = new ArrayList<AdditionalServiceDeclaration>();
        result.add(new AdditionalServiceDeclaration(MessageChannelLifecycleListener.class, (Object)new MessageChannelLifecycleListenerAdapter(){

            @Override
            public void onOutgoingChannelTerminated(MessageChannel connection) {
                ConnectionSetupServiceImpl.this.handleOutgoingChannelTerminated(connection);
            }
        }));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionSetup createConnectionSetup(NetworkContactPoint ncp, String displayName, boolean connnectOnStartup) {
        ConnectionSetupListenerAdapter stateChangeListenerAdapter = new ConnectionSetupListenerAdapter(){

            @Override
            public void onStateChanged(final ConnectionSetup setup, final ConnectionSetupState oldState, final ConnectionSetupState newState) {
                ConnectionSetupServiceImpl.this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<ConnectionSetupListener>(){

                    public void performCallback(ConnectionSetupListener listener) {
                        listener.onStateChanged(setup, oldState, newState);
                    }
                });
            }

            @Override
            public void onConnectionAttemptFailed(final ConnectionSetup setup, final boolean firstConsecutiveFailure, final boolean willAutoRetry) {
                ConnectionSetupServiceImpl.this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<ConnectionSetupListener>(){

                    public void performCallback(ConnectionSetupListener listener) {
                        listener.onConnectionAttemptFailed(setup, firstConsecutiveFailure, willAutoRetry);
                    }
                });
            }

            @Override
            public void onConnectionClosed(final ConnectionSetup setup, final DisconnectReason disconnectReason, final boolean willAutoRetry) {
                ConnectionSetupServiceImpl.this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<ConnectionSetupListener>(){

                    public void performCallback(ConnectionSetupListener listener) {
                        listener.onConnectionClosed(setup, disconnectReason, willAutoRetry);
                    }
                });
            }
        };
        long id = this.lastSetupId.incrementAndGet();
        final ConnectionSetupImpl newSetup = new ConnectionSetupImpl(ncp, displayName, id, connnectOnStartup, this.messageChannelService, stateChangeListenerAdapter);
        List<ConnectionSetup> list = this.setups;
        synchronized (list) {
            this.setups.add(newSetup);
            final List<ConnectionSetup> snapshotOfCollection = this.createDetachedSnapshotOfCollection();
            this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<ConnectionSetupListener>(){

                public void performCallback(ConnectionSetupListener listener) {
                    listener.onCollectionChanged(snapshotOfCollection);
                    listener.onCreated(newSetup);
                }
            });
        }
        return newSetup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disposeConnectionSetup(final ConnectionSetup setup) {
        setup.signalStopIntent();
        List<ConnectionSetup> list = this.setups;
        synchronized (list) {
            boolean wasContained = this.setups.remove(setup);
            if (!wasContained) {
                this.log.warn((Object)("Connection setup '" + setup.getDisplayName() + "' was not found in the registry when dispose() was called"));
            }
            final List<ConnectionSetup> snapshotOfCollection = this.createDetachedSnapshotOfCollection();
            this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<ConnectionSetupListener>(){

                public void performCallback(ConnectionSetupListener listener) {
                    listener.onDisposed(setup);
                    listener.onCollectionChanged(snapshotOfCollection);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ConnectionSetup> getAllConnectionSetups() {
        List<ConnectionSetup> list = this.setups;
        synchronized (list) {
            return this.createDetachedSnapshotOfCollection();
        }
    }

    @Override
    public ConnectionSetup getConnectionSetupById(long id) {
        for (ConnectionSetup setup : this.setups) {
            if (setup.getId() != id) continue;
            return setup;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionSetupListener(ConnectionSetupListener listener) {
        List<ConnectionSetup> list = this.setups;
        synchronized (list) {
            final List<ConnectionSetup> snapshotOfCollection = this.createDetachedSnapshotOfCollection();
            this.callbackManager.addListenerAndEnqueueCallback((Object)listener, (AsyncCallback)new AsyncCallback<ConnectionSetupListener>(){

                public void performCallback(ConnectionSetupListener listener) {
                    listener.onCollectionChanged(snapshotOfCollection);
                }
            });
        }
    }

    public void removeConnectionSetupListener(ConnectionSetupListener listener) {
        this.callbackManager.removeListener((Object)listener);
    }

    public void bindMessageChannelService(MessageChannelService newInstance) {
        this.messageChannelService = newInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOutgoingChannelTerminated(MessageChannel messageChannel) {
        ConnectionSetupImpl matchedSetup = null;
        String channelId = messageChannel.getChannelId();
        List<ConnectionSetup> list = this.setups;
        synchronized (list) {
            for (ConnectionSetup setup : this.setups) {
                if (!channelId.equals(setup.getLastChannelId())) continue;
                matchedSetup = (ConnectionSetupImpl)setup;
                break;
            }
        }
        if (messageChannel.getInitiatedByRemote()) {
            if (matchedSetup != null) {
                ConsistencyChecks.reportFailure((String)("Remote-initiated message channel had an associated connection setup: " + channelId));
            }
            return;
        }
        if (matchedSetup == null) {
            this.log.warn((Object)("Self-initiated message channel closed, but no associated connection setup found: " + channelId));
            return;
        }
        matchedSetup.onMessageChannelClosed(messageChannel);
    }

    private List<ConnectionSetup> createDetachedSnapshotOfCollection() {
        return Collections.unmodifiableList(new ArrayList<ConnectionSetup>(this.setups));
    }
}

