/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.file.service.legacy.internal;

import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.common.InstanceNodeId;
import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import de.rcenvironment.core.communication.fileaccess.api.RemoteFileConnection;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.Assertions;
import java.net.URI;

public final class RCEFileURIUtils {
    private static final String PARAMETER_URI = "uri";
    private static final String RCE = "rce";
    private static final String ERROR_URI_IS_INVALID = "The URI is invalid: ";
    private static final String ERROR_PARAMETERS_NULL = "The parameter \"%s\" must not be null.";

    private RCEFileURIUtils() {
    }

    public static RemoteFileConnection.FileType getType(URI uri) throws CommunicationException {
        Assertions.isDefined((Object)uri, (String)StringUtils.format((String)ERROR_PARAMETERS_NULL, (Object[])new Object[]{PARAMETER_URI}));
        if (!uri.isAbsolute()) {
            throw new CommunicationException("The URI is invalid: scheme is missing.");
        }
        if (uri.getScheme().equals(RCE)) {
            return RemoteFileConnection.FileType.RCE_DM;
        }
        throw new CommunicationException("Scheme unknown: " + uri.getScheme());
    }

    public static InstanceNodeId getNodeIdentifier(URI uri) throws CommunicationException {
        Assertions.isDefined((Object)uri, (String)StringUtils.format((String)ERROR_PARAMETERS_NULL, (Object[])new Object[]{PARAMETER_URI}));
        RCEFileURIUtils.validateURI(uri);
        return NodeIdentifierUtils.parseInstanceNodeIdStringWithExceptionWrapping((String)uri.getHost());
    }

    public static String getPath(URI uri) throws CommunicationException {
        Assertions.isDefined((Object)uri, (String)StringUtils.format((String)ERROR_PARAMETERS_NULL, (Object[])new Object[]{PARAMETER_URI}));
        RCEFileURIUtils.validateURI(uri);
        return uri.getPath().replaceFirst("/", "");
    }

    private static void validateURI(URI uri) throws CommunicationException {
        Assertions.isDefined((Object)uri, (String)StringUtils.format((String)ERROR_PARAMETERS_NULL, (Object[])new Object[]{PARAMETER_URI}));
        String host = uri.getHost();
        if (host == null || host.trim().isEmpty()) {
            throw new CommunicationException("The URI is invalid: host is missing.");
        }
        String path = uri.getPath();
        if (path == null || path.trim().isEmpty()) {
            throw new CommunicationException("The URI is invalid: path is missing.");
        }
    }
}

