/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.xml.values.execution;

import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.model.spi.DefaultComponent;
import de.rcenvironment.core.component.xml.api.EndpointXMLService;
import de.rcenvironment.core.datamodel.api.DataTypeException;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.utils.common.TempFileService;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XmlValuesComponent
extends DefaultComponent {
    private static final String FAILED_TO_DELETE_TEMP_FILE = "Failed to delete temp file: ";
    private static final Log LOG = LogFactory.getLog(XmlValuesComponent.class);
    private ComponentContext componentContext;
    private ComponentDataManagementService dataManagementService;
    private EndpointXMLService endpointXmlUtils;
    private File tempMainFile = null;

    public void setComponentContext(ComponentContext componentContext) {
        this.componentContext = componentContext;
    }

    public final void start() throws ComponentException {
        this.dataManagementService = (ComponentDataManagementService)this.componentContext.getService(ComponentDataManagementService.class);
        this.endpointXmlUtils = (EndpointXMLService)this.componentContext.getService(EndpointXMLService.class);
    }

    public void processInputs() throws ComponentException {
        FileReferenceTD fileReference;
        TempFileService tempFileService = TempFileServiceAccess.getInstance();
        FileReferenceTD mainXml = (FileReferenceTD)this.componentContext.readInput("XML");
        HashMap<String, TypedDatum> variableInputs = new HashMap<String, TypedDatum>();
        for (String inputName : this.componentContext.getInputsWithDatum()) {
            if (!this.componentContext.isDynamicInput(inputName) || inputName.equals("XML")) continue;
            variableInputs.put(inputName, this.componentContext.readInput(inputName));
        }
        try {
            this.tempMainFile = tempFileService.createTempFileFromPattern("XMLValues-*.xml");
            this.dataManagementService.copyReferenceToLocalFile(mainXml.getFileReference(), this.tempMainFile, (ResolvableNodeId)this.componentContext.getDefaultStorageNodeId());
        }
        catch (IOException e) {
            throw new ComponentException("Failed to write XML file into a temporary file (that is required for XML Values)", (Throwable)e);
        }
        try {
            this.endpointXmlUtils.updateXMLWithInputs(this.tempMainFile, variableInputs, this.componentContext);
        }
        catch (DataTypeException e) {
            throw new ComponentException("Failed to add dynamic input values to the XML file", (Throwable)e);
        }
        try {
            fileReference = this.dataManagementService.createFileReferenceTDFromLocalFile(this.componentContext, this.tempMainFile, mainXml.getFileName());
        }
        catch (IOException e) {
            throw new ComponentException("Failed to store updated XML file into the data management - if it is not stored in the data management, it can not be sent as output value", (Throwable)e);
        }
        try {
            this.endpointXmlUtils.updateOutputsFromXML(this.tempMainFile, this.componentContext);
        }
        catch (DataTypeException e) {
            throw new ComponentException("Failed to extract the entry at " + this.endpointXmlUtils.getRecentXpath() + " from the XML file", (Throwable)e);
        }
        this.componentContext.writeOutput("XML", (TypedDatum)fileReference);
        this.deleteTempFiles();
    }

    private void deleteTempFiles() {
        TempFileService tempFileService = TempFileServiceAccess.getInstance();
        try {
            if (this.tempMainFile != null) {
                tempFileService.disposeManagedTempDirOrFile(this.tempMainFile);
            }
        }
        catch (IOException e) {
            LOG.error((Object)(FAILED_TO_DELETE_TEMP_FILE + this.tempMainFile.getAbsolutePath()), (Throwable)e);
        }
    }
}

