/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.script.gui;

import de.rcenvironment.components.script.common.registry.ScriptExecutorFactoryRegistry;
import de.rcenvironment.components.script.gui.Messages;
import de.rcenvironment.core.gui.workflow.executor.properties.AbstractScriptSection;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import de.rcenvironment.core.utils.scripting.ScriptLanguage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ScriptSection
extends AbstractScriptSection {
    private static final Log LOGGER = LogFactory.getLog(ScriptSection.class);
    private CCombo languages;

    public ScriptSection() {
        super(Messages.scriptname);
    }

    protected void createCompositeContentAtVeryTop(Composite composite, TabbedPropertySheetWidgetFactory factory) {
        Composite scriptParent = factory.createFlatFormComposite(composite);
        scriptParent.setLayout((Layout)new RowLayout());
        new Label(scriptParent, 0).setText(Messages.chooseLanguage);
        this.languages = new CCombo(scriptParent, 2056);
        this.languages.setData("property.control", (Object)"scriptLanguage");
        ServiceRegistryAccess serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)((Object)this));
        ScriptExecutorFactoryRegistry scriptExecutorRegistry = (ScriptExecutorFactoryRegistry)serviceRegistryAccess.getService(ScriptExecutorFactoryRegistry.class);
        List languagesForCombo = scriptExecutorRegistry.getCurrentRegisteredExecutorLanguages();
        for (ScriptLanguage sl : languagesForCombo) {
            this.languages.add(sl.getName());
        }
    }

    public void refreshSection() {
        super.refreshSection();
        if ((this.getProperty("scriptLanguage") == null || this.getProperty("scriptLanguage").isEmpty() || this.languages.getText().equals("\"\"")) && this.languages.getItemCount() > 0) {
            this.languages.select(0);
        }
        if (this.getProperty("script") == null || this.getProperty("script").equals("import sys\n\nsys.stderr.write('Script was not configured')\nsys.stderr.flush()")) {
            try {
                InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/resources/defaultScript.py") == null ? new FileInputStream("./resources/defaultScript.py") : ((Object)((Object)this)).getClass().getResourceAsStream("/resources/defaultScript.py");
                String returnValue = IOUtils.toString((InputStream)is);
                IOUtils.closeQuietly((InputStream)is);
                this.setProperty("script", returnValue);
            }
            catch (IOException e) {
                LOGGER.error((Object)e.getMessage());
            }
        }
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.refresh();
    }
}

