/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.cpacs.writer.execution;

import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.datamanagement.api.ComponentHistoryDataItem;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.execution.api.ComponentLog;
import de.rcenvironment.core.component.model.api.LazyDisposal;
import de.rcenvironment.core.component.model.spi.DefaultComponent;
import de.rcenvironment.core.component.xml.XmlComponentHistoryDataItem;
import de.rcenvironment.core.component.xml.api.EndpointXMLService;
import de.rcenvironment.core.datamodel.api.DataTypeException;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.notification.DistributedNotificationService;
import de.rcenvironment.core.utils.common.LogUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@LazyDisposal
public class CpacsWriterComponent
extends DefaultComponent {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private ComponentContext componentContext;
    private ComponentLog componentLog;
    private DistributedNotificationService notificationService;
    private ComponentDataManagementService dataManagementService;
    private boolean overwriteEachRun = true;
    private XmlComponentHistoryDataItem historyDataItem = null;
    private EndpointXMLService endpointXmlService;
    private File localFolder;
    private File tempFile;

    public void setComponentContext(ComponentContext componentContext) {
        this.componentContext = componentContext;
        this.componentLog = componentContext.getLog();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void start() throws ComponentException {
        this.dataManagementService = (ComponentDataManagementService)this.componentContext.getService(ComponentDataManagementService.class);
        this.endpointXmlService = (EndpointXMLService)this.componentContext.getService(EndpointXMLService.class);
        this.notificationService = (DistributedNotificationService)this.componentContext.getService(DistributedNotificationService.class);
        this.notificationService.setBufferSize(String.valueOf(this.componentContext.getExecutionIdentifier()) + ":rce.component.cpacswriter", 1);
        this.overwriteEachRun = Boolean.parseBoolean(this.componentContext.getConfigurationValue("saveMode"));
        String localStore = this.componentContext.getConfigurationValue("localFolder");
        if (localStore != null && !localStore.trim().isEmpty()) {
            File folder = new File(localStore);
            if (folder.isAbsolute()) {
                this.localFolder = folder;
                return;
            }
            this.localFolder = null;
            throw new ComponentException("Failed to write CPACS file as the given path is invalid, it must be an absolute one: " + folder.getPath());
        }
        this.localFolder = null;
        this.componentLog.componentInfo("Incoming CPACS file(s) not stored to local file system as no path is configured");
    }

    public void processInputs() throws ComponentException {
        this.initializeNewHistoryDataItem();
        FileReferenceTD cpacsFileRef = (FileReferenceTD)this.componentContext.readInput("CPACS");
        HashMap<String, TypedDatum> varInputs = new HashMap<String, TypedDatum>();
        for (String inputName : this.componentContext.getInputsWithDatum()) {
            if (!this.componentContext.isDynamicInput(inputName)) continue;
            varInputs.put(inputName, this.componentContext.readInput(inputName));
        }
        if (!varInputs.isEmpty() || this.hasDynamicOutputs()) {
            String fileName;
            try {
                this.tempFile = TempFileServiceAccess.getInstance().createTempFileWithFixedFilename("cpacs.xml");
                this.dataManagementService.copyReferenceToLocalFile(cpacsFileRef.getFileReference(), this.tempFile, (ResolvableNodeId)this.componentContext.getDefaultStorageNodeId());
            }
            catch (IOException e) {
                this.logError("Failed to write CPACS file into a temporary file (that is required for CPACS Writer) - skip run", e);
                return;
            }
            boolean updated = false;
            try {
                this.endpointXmlService.updateXMLWithInputs(this.tempFile, varInputs, this.componentContext);
                updated = true;
            }
            catch (DataTypeException e) {
                this.logError("Failed to add dynamic input values to the CPACS file", (Exception)((Object)e));
            }
            if (updated) {
                fileName = this.getFileName("cpacs_with_variables");
                try {
                    cpacsFileRef = this.dataManagementService.createFileReferenceTDFromLocalFile(this.componentContext, this.tempFile, fileName);
                }
                catch (IOException e) {
                    this.logError("Failed to store the CPACS file with variables into the data management - if it is not stored in the data management, it can not be sent as output value", e);
                }
                if (!varInputs.isEmpty() && this.historyDataItem != null) {
                    this.historyDataItem.setXmlWithVariablesFileReference(cpacsFileRef.getFileReference());
                    this.storeHistoryDataItem();
                }
            } else {
                fileName = this.getFileName("cpacs");
            }
            if (this.localFolder != null) {
                try {
                    File file = new File(this.localFolder, fileName);
                    FileUtils.copyFile((File)this.tempFile, (File)file);
                    this.componentLog.componentInfo("Stored CPACS file to: " + file.getAbsolutePath());
                }
                catch (IOException e) {
                    this.logError("Failed to store CPACS file to the local file system", e);
                }
            }
            if (this.hasDynamicOutputs()) {
                try {
                    this.endpointXmlService.updateOutputsFromXML(this.tempFile, this.componentContext);
                }
                catch (DataTypeException e) {
                    this.logError("Failed to read dynamic output values from the CPACS file", (Exception)((Object)e));
                }
            }
        } else {
            String fileName = this.getFileName("cpacs");
            if (this.localFolder != null) {
                try {
                    File file = new File(this.localFolder, fileName);
                    this.dataManagementService.copyReferenceToLocalFile(cpacsFileRef.getFileReference(), file, (ResolvableNodeId)this.componentContext.getDefaultStorageNodeId());
                    this.componentLog.componentInfo("Stored CPACS file to: " + file.getAbsolutePath());
                }
                catch (IOException e) {
                    this.logError("Failed to store CPACS file to the local file system", e);
                }
            }
        }
        this.sendCPACSFile(cpacsFileRef);
        this.deleteTempFile();
    }

    private void logError(String message, Exception e) {
        String errorId = LogUtils.logExceptionWithStacktraceAndAssignUniqueMarker((Log)this.log, (String)message, (Throwable)e);
        this.componentLog.componentError(message, (Throwable)e, errorId);
    }

    private void sendCPACSFile(FileReferenceTD cpacsFileRef) {
        this.componentContext.writeOutput("CPACS", (TypedDatum)cpacsFileRef);
        this.notificationService.send(String.valueOf(this.componentContext.getExecutionIdentifier()) + ":rce.component.cpacswriter", (Serializable)((Object)cpacsFileRef.getFileReference()));
    }

    public void completeStartOrProcessInputsAfterFailure() throws ComponentException {
        this.storeHistoryDataItem();
        this.deleteTempFile();
    }

    private void initializeNewHistoryDataItem() {
        if (Boolean.valueOf(this.componentContext.getConfigurationValue("storeComponentHistoryData")).booleanValue()) {
            this.historyDataItem = new XmlComponentHistoryDataItem("de.rcenvironment.cpacswriter");
        }
    }

    private void storeHistoryDataItem() {
        if (Boolean.valueOf(this.componentContext.getConfigurationValue("storeComponentHistoryData")).booleanValue()) {
            this.componentContext.writeFinalHistoryDataItem((ComponentHistoryDataItem)this.historyDataItem);
        }
    }

    private String getFileName(String name) {
        String fileName = !this.overwriteEachRun ? StringUtils.format((String)"%s_%d.xml", (Object[])new Object[]{name, this.componentContext.getExecutionCount()}) : StringUtils.format((String)"%s.xml", (Object[])new Object[]{name});
        return fileName;
    }

    private boolean hasDynamicOutputs() {
        for (String outputName : this.componentContext.getOutputs()) {
            if (!this.componentContext.isDynamicOutput(outputName)) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
        if (this.componentContext != null && this.notificationService != null) {
            this.notificationService.removePublisher(String.valueOf(this.componentContext.getExecutionIdentifier()) + ":rce.component.cpacswriter");
        }
    }

    private void deleteTempFile() {
        if (this.tempFile != null) {
            try {
                TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(this.tempFile);
            }
            catch (IOException e) {
                LogFactory.getLog(((Object)((Object)this)).getClass()).error((Object)("Failed to delete temp file: " + this.tempFile.getAbsolutePath()), (Throwable)e);
            }
        }
    }
}

