/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.toolkit.modules.concurrency.api.threadcontext;

import de.rcenvironment.toolkit.modules.concurrency.api.threadcontext.ThreadContext;
import de.rcenvironment.toolkit.modules.concurrency.api.threadcontext.ThreadContextMemento;

public final class ThreadContextHolder {
    private static final ThreadLocal<ThreadContext> sharedThreadLocal = new ThreadLocal();

    private ThreadContextHolder() {
    }

    public static ThreadContext getCurrentContext() {
        return sharedThreadLocal.get();
    }

    public static <T> T getCurrentContextAspect(Class<T> aspectClass) {
        ThreadContext threadContext = sharedThreadLocal.get();
        if (threadContext == null) {
            return null;
        }
        return threadContext.getAspect(aspectClass);
    }

    public static ThreadContextMemento setCurrentContext(ThreadContext newContext) {
        ThreadContext savedContext = sharedThreadLocal.get();
        sharedThreadLocal.set(newContext);
        return new ThreadContextMementoImpl(savedContext, newContext);
    }

    private static final class ThreadContextMementoImpl
    implements ThreadContextMemento {
        private final ThreadContext savedContext;
        private final ThreadContext newContext;

        ThreadContextMementoImpl(ThreadContext previous, ThreadContext newContext) {
            this.savedContext = previous;
            this.newContext = newContext;
        }

        @Override
        public void restore() {
            if (sharedThreadLocal.get() != this.newContext) {
                throw new IllegalStateException("Consistency violation: Found a different " + ThreadContext.class.getSimpleName() + " instance than the one that was set when this " + ThreadContextMemento.class.getSimpleName() + " was created. Most likely, a subsequent context change operation was not unwound " + "after its nested operation was finished.");
            }
            sharedThreadLocal.set(this.savedContext);
        }
    }
}

