/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.ssh.jsch.executor.context;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import de.rcenvironment.core.utils.common.validation.ValidationFailureException;
import de.rcenvironment.core.utils.executor.CommandLineExecutor;
import de.rcenvironment.core.utils.executor.context.spi.ExecutorContext;
import de.rcenvironment.core.utils.ssh.jsch.JschSessionFactory;
import de.rcenvironment.core.utils.ssh.jsch.SshParameterException;
import de.rcenvironment.core.utils.ssh.jsch.SshSessionConfiguration;
import de.rcenvironment.core.utils.ssh.jsch.executor.JSchCommandLineExecutor;
import de.rcenvironment.core.utils.ssh.jsch.executor.context.RemoteTempDirFactory;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JSchExecutorContext
implements ExecutorContext {
    private Session jschSession;
    private SshSessionConfiguration staticConfiguration;
    private RemoteTempDirFactory tempDirFactory;
    private final Log log = LogFactory.getLog(this.getClass());

    public JSchExecutorContext(SshSessionConfiguration staticConfiguration) {
        this(staticConfiguration, "/tmp/rce-tmp/");
    }

    public JSchExecutorContext(SshSessionConfiguration staticConfiguration, String tempDirRoot) {
        this.staticConfiguration = staticConfiguration;
        this.tempDirFactory = new RemoteTempDirFactory(tempDirRoot);
    }

    public void setUpSession() throws IOException, ValidationFailureException {
        try {
            this.jschSession = this.setupJSchSession();
            this.log.info((Object)"SSH connection established");
        }
        catch (JSchException e) {
            throw new IOException(e);
        }
        catch (SshParameterException e) {
            throw new ValidationFailureException(e.getMessage());
        }
    }

    public void tearDownSession() throws IOException {
        if (this.jschSession == null) {
            throw new IllegalStateException("session not set up");
        }
        this.log.info((Object)"Closing SSH connection");
        this.jschSession.disconnect();
    }

    public CommandLineExecutor setUpSandboxedExecutor() throws IOException {
        if (this.jschSession == null) {
            throw new IllegalStateException("no session set up");
        }
        String sandboxDir = this.tempDirFactory.createTempDirPath("sandbox", "-");
        this.log.debug((Object)("Setting SSH sandbox to " + sandboxDir));
        JSchCommandLineExecutor executor = new JSchCommandLineExecutor(this.jschSession, this.tempDirFactory.getRootDir());
        String sandboxDirName = new File(sandboxDir).getName();
        try {
            executor.start("mkdir -p " + sandboxDirName);
            executor.waitForTermination();
        }
        catch (InterruptedException e) {
            this.log.warn((Object)"Interrupted while setting up remote SSH sandbox", (Throwable)e);
        }
        return new JSchCommandLineExecutor(this.jschSession, sandboxDir);
    }

    public void tearDownSandbox(CommandLineExecutor executor) throws IOException {
        if (this.jschSession == null) {
            throw new IllegalStateException("no session set up");
        }
        String sandboxPath = executor.getWorkDirPath();
        this.log.debug((Object)("Cleaning SSH sandbox at " + sandboxPath));
        try {
            executor.start("rm " + sandboxPath + "/*");
            executor.waitForTermination();
            executor.start("rmdir " + sandboxPath);
            executor.waitForTermination();
        }
        catch (InterruptedException e) {
            this.log.warn((Object)"Interrupted while cleaning up remote SSH sandbox", (Throwable)e);
        }
    }

    public String createUniqueTempDir(String contextHint) throws IOException {
        String tempDirPath = this.tempDirFactory.createTempDirPath(contextHint, "-");
        this.log.debug((Object)("Generated temp directory path " + tempDirPath));
        return tempDirPath;
    }

    private Session setupJSchSession() throws JSchException, SshParameterException {
        String host = this.staticConfiguration.getDestinationHost();
        int port = this.staticConfiguration.getPort();
        String user = this.staticConfiguration.getSshAuthUser();
        String keyfileLocation = this.staticConfiguration.getSshKeyFileLocation();
        String authPhrase = this.staticConfiguration.getSshAuthPhrase();
        Logger jschLogger = new Logger(){

            public boolean isEnabled(int arg0) {
                return true;
            }

            public void log(int arg0, String arg1) {
                if (JSchExecutorContext.this.log.isTraceEnabled()) {
                    JSchExecutorContext.this.log.trace((Object)("JSch Log [Level " + arg0 + "]: " + arg1));
                }
            }
        };
        return JschSessionFactory.setupSession(host, port, user, keyfileLocation, authPhrase, jschLogger);
    }
}

