/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.scripting.python;

import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallbackExceptionPolicy;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncOrderedExecutionQueue;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class PythonOutputWriter
extends Writer {
    public static final String CONSOLE_END = "c02abd1c-67bc-4974-902b-439cd2b14efc";
    public static final int WAIT_FOR_CONSOLE_END_TIMEOUT_IN_MILI_SEC = 5000;
    protected final AsyncOrderedExecutionQueue executionQueue;
    private final Log log = LogFactory.getLog(this.getClass());
    private final StringBuilder buffer = new StringBuilder();
    private FileOutputStream logFileStream;
    private final Object logFileLock = new Object();
    private boolean isClosed = false;
    private final CountDownLatch finishLatch = new CountDownLatch(1);

    public PythonOutputWriter(Object lock, File logFile) {
        super(lock);
        this.executionQueue = ConcurrencyUtils.getFactory().createAsyncOrderedExecutionQueue(AsyncCallbackExceptionPolicy.LOG_AND_PROCEED);
        if (logFile != null) {
            try {
                this.logFileStream = new FileOutputStream(logFile);
            }
            catch (FileNotFoundException e) {
                LogFactory.getLog(this.getClass()).error((Object)"Creating stream for given log file failed", (Throwable)e);
            }
        }
    }

    protected abstract void onNewLineToForward(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.buffer.append(cbuf, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            String line = this.buffer.toString();
            this.buffer.setLength(0);
            if (this.isClosed) {
                if (!line.isEmpty()) {
                    this.log.warn((Object)("Unexpected caller behavior: flush() called after close(); captured output=" + line));
                }
            } else if (line.contains(CONSOLE_END)) {
                this.isClosed = true;
                this.forwardLine(null);
                this.finishLatch.countDown();
            } else {
                this.forwardLine(line);
            }
        }
    }

    protected void forwardLine(final String line) {
        this.executionQueue.enqueue(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = PythonOutputWriter.this.logFileLock;
                synchronized (object) {
                    if (PythonOutputWriter.this.logFileStream != null && line != null) {
                        try {
                            PythonOutputWriter.this.logFileStream.write(line.getBytes());
                        }
                        catch (IOException e) {
                            PythonOutputWriter.this.log.error((Object)"Writing output to file failed", (Throwable)e);
                        }
                    }
                }
                PythonOutputWriter.this.onNewLineToForward(line);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.finishLatch.await(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            this.log.error((Object)"Waiting for last console line was interrupted. Writer instance will be closed immediately. Console lines might be lost");
        }
        Object object = this.logFileLock;
        synchronized (object) {
            if (this.logFileStream != null) {
                this.logFileStream.close();
                this.logFileStream = null;
            }
        }
        object = this.lock;
        synchronized (object) {
            this.isClosed = true;
        }
    }
}

