/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.embedded.ssh.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.rcenvironment.core.embedded.ssh.api.SshAccount;
import de.rcenvironment.core.embedded.ssh.internal.SshAccountRole;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;

public class SshAccountImpl
implements SshAccount {
    private String loginName;
    private String password;
    private String passwordHash;
    private String publicKey;
    @JsonIgnore
    private PublicKey publicKeyObj;
    private String role = "";
    private boolean enabled = true;

    public SshAccountImpl() {
    }

    public SshAccountImpl(String username, String password, String passwordHash, String publicKey, String role) {
        this.loginName = username;
        this.password = password;
        this.passwordHash = passwordHash;
        this.publicKey = publicKey;
        this.role = role;
        this.parsePublicKey();
    }

    public boolean validate(List<SshAccountRole> roles, Log log) {
        boolean isValid = true;
        boolean noMatchingRole = true;
        if (this.loginName == null || this.loginName.isEmpty()) {
            log.warn((Object)"Found a user without username");
            isValid = false;
        }
        if (isValid && this.password != null) {
            log.warn((Object)("SSH user \"" + this.loginName + "\" has an insecure clear-text password. " + "Refer to the RCE User Guide on how to change it to a secure format."));
        }
        if (!(this.password != null && !this.password.isEmpty() || this.passwordHash != null && !this.passwordHash.isEmpty() || this.publicKey != null && !this.publicKey.isEmpty())) {
            log.warn((Object)("User \"" + this.loginName + "\" does not have a password, password hash, or public key"));
            isValid = false;
        }
        if (this.password != null && this.passwordHash != null) {
            log.warn((Object)("User \"" + this.loginName + "\" has both a clear-text and a hashed password at the same time"));
            isValid = false;
        }
        if (this.publicKey != null && !this.publicKey.isEmpty() && this.publicKeyObj == null) {
            log.warn((Object)("SSH User \"" + this.loginName + "\" has an invalid public key (only RSA keys are valid)"));
            isValid = false;
        }
        if (this.role == null) {
            log.warn((Object)("Changed role for user \"" + this.loginName + "\" from null to empty string"));
            this.role = "";
        }
        for (SshAccountRole curRole : roles) {
            if (!this.role.equals(curRole.getRoleName())) continue;
            noMatchingRole = false;
            break;
        }
        if (noMatchingRole) {
            log.warn((Object)("Non-existing role \"" + this.role + "\" configured for user \"" + this.loginName + "\". Default permissions (\"help\", \"exit\", \"version\") will be used."));
        }
        return isValid;
    }

    @Override
    public String getLoginName() {
        return this.loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getPasswordHash() {
        return this.passwordHash;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
        this.parsePublicKey();
    }

    @Override
    @JsonIgnore
    public PublicKey getPublicKeyObj() {
        return this.publicKeyObj;
    }

    @Override
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private void parsePublicKey() {
        if (this.publicKey != null && !this.publicKey.isEmpty()) {
            try {
                byte[] encKey = Base64.decodeBase64((String)this.publicKey.split(" ")[1]);
                DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(encKey));
                byte[] header = SshAccountImpl.readElement(inputStream);
                String pubKeyFormat = new String(header);
                if (pubKeyFormat.equals("ssh-rsa")) {
                    byte[] publicExponent = SshAccountImpl.readElement(inputStream);
                    byte[] modulus = SshAccountImpl.readElement(inputStream);
                    RSAPublicKeySpec spec = new RSAPublicKeySpec(new BigInteger(modulus), new BigInteger(publicExponent));
                    KeyFactory kf = KeyFactory.getInstance("RSA");
                    this.publicKeyObj = kf.generatePublic(spec);
                }
            }
            catch (IOException | ArrayIndexOutOfBoundsException | NoSuchAlgorithmException | InvalidKeySpecException exception) {
                this.publicKeyObj = null;
            }
        }
    }

    private static byte[] readElement(DataInput dataInput) throws IOException {
        int len = dataInput.readInt();
        byte[] buf = new byte[len];
        dataInput.readFully(buf);
        return buf;
    }
}

