/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.api;

import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.component.execution.api.ComponentExecutionContext;
import de.rcenvironment.core.component.execution.api.WorkflowGraph;
import de.rcenvironment.core.component.execution.impl.ComponentExecutionContextImpl;
import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDatumRecipient;
import java.util.List;
import java.util.Map;

public class ComponentExecutionContextBuilder {
    private ComponentExecutionContextImpl compExeCtx = new ComponentExecutionContextImpl();

    public ComponentExecutionContextBuilder setExecutionIdentifiers(String executionIdentifier, String workflowExecutionIdentifier) {
        this.compExeCtx.setExecutionIdentifier(executionIdentifier);
        this.compExeCtx.setWorkflowExecutionIdentifier(workflowExecutionIdentifier);
        return this;
    }

    public ComponentExecutionContextBuilder setInstanceNames(String instanceName, String workflowInstanceName) {
        this.compExeCtx.setInstanceName(instanceName);
        this.compExeCtx.setWorkflowInstanceName(workflowInstanceName);
        return this;
    }

    public ComponentExecutionContextBuilder setNodes(LogicalNodeId workflowNode, LogicalNodeId defaultStorageNode) {
        this.compExeCtx.setWorkflowNodeId(workflowNode);
        this.compExeCtx.setDefaultStorageNode(defaultStorageNode);
        return this;
    }

    public ComponentExecutionContextBuilder setComponentDescription(ComponentDescription componentDescription) {
        this.compExeCtx.setComponentDescription(componentDescription);
        return this;
    }

    public ComponentExecutionContextBuilder setPredecessorAndSuccessorInformation(boolean isConnectedToEndpointDatumSenders, Map<String, List<EndpointDatumRecipient>> endpointDatumRecipients) {
        this.compExeCtx.setIsConnectedToEndpointDatumSenders(isConnectedToEndpointDatumSenders);
        this.compExeCtx.setEndpointDatumRecipients(endpointDatumRecipients);
        return this;
    }

    public ComponentExecutionContextBuilder setWorkflowGraph(WorkflowGraph workflowGraph) {
        this.compExeCtx.setWorkflowGraph(workflowGraph);
        return this;
    }

    public ComponentExecutionContextBuilder setDataManagementIds(Long workflowInstanceDataManagementId, Long instanceDataManagementId, Map<String, Long> inputDataManagementIds, Map<String, Long> outputDataManagementIds) {
        this.compExeCtx.setWorkflowInstanceDataManagementId(workflowInstanceDataManagementId);
        this.compExeCtx.setInstanceDataManagementId(instanceDataManagementId);
        this.compExeCtx.setInputDataManagementIds(inputDataManagementIds);
        this.compExeCtx.setOutputDataManagementIds(outputDataManagementIds);
        return this;
    }

    public ComponentExecutionContext build() {
        return this.compExeCtx;
    }
}

