/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.integration.internal;

import de.rcenvironment.core.component.integration.ToolIntegrationContext;
import de.rcenvironment.core.component.integration.ToolIntegrationService;
import de.rcenvironment.core.component.integration.internal.ToolIntegrationFileWatcher;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ToolIntegrationFileWatcherManager {
    private static final Log LOGGER = LogFactory.getLog(ToolIntegrationFileWatcherManager.class);
    private static final String COULD_NOT_CREATE_A_WATCH_SERVICE_FOR_THE_FILE = "Could not create a WatchService for the file: ";
    private ToolIntegrationService integrationService;
    private Map<ToolIntegrationContext, ToolIntegrationFileWatcher> watchers;

    public ToolIntegrationFileWatcherManager(ToolIntegrationService integrationService) {
        this.integrationService = integrationService;
        this.watchers = new HashMap<ToolIntegrationContext, ToolIntegrationFileWatcher>();
    }

    public void createWatcherForToolRootDirectory(ToolIntegrationContext context) {
        File integrationRootFolder = new File(context.getRootPathToToolIntegrationDirectory(), context.getNameOfToolIntegrationDirectory());
        if (!integrationRootFolder.exists()) {
            integrationRootFolder.mkdirs();
        }
        try {
            Path toolIntegrationPath = FileSystems.getDefault().getPath(integrationRootFolder.getAbsolutePath(), new String[0]);
            ToolIntegrationFileWatcher integrationWatcher = new ToolIntegrationFileWatcher(context, this.integrationService);
            ConcurrencyUtils.getAsyncTaskService().execute((Runnable)integrationWatcher, "FileWatcher " + context.getContextId());
            integrationWatcher.registerRecursive(toolIntegrationPath);
            this.watchers.put(context, integrationWatcher);
            LOGGER.debug((Object)("Created new watcher for context " + context.getContextType()));
        }
        catch (IOException e) {
            LOGGER.warn((Object)(COULD_NOT_CREATE_A_WATCH_SERVICE_FOR_THE_FILE + integrationRootFolder.getAbsolutePath()), (Throwable)e);
        }
    }

    public void unregisterRootDirectory(ToolIntegrationContext context) {
        File integrationRootFolder = new File(context.getRootPathToToolIntegrationDirectory(), context.getNameOfToolIntegrationDirectory());
        ToolIntegrationFileWatcher integrationWatcher = this.watchers.get(context);
        if (integrationWatcher != null) {
            try {
                integrationWatcher.unregisterRecursive(FileSystems.getDefault().getPath(integrationRootFolder.getAbsolutePath(), new String[0]));
            }
            catch (IOException e) {
                LOGGER.warn((Object)("Could not unregister integration root folder: " + integrationRootFolder.getAbsolutePath()), (Throwable)e);
            }
            integrationWatcher.stop();
            this.watchers.remove(integrationWatcher);
        }
        LOGGER.debug((Object)("Unregistered watcher for context " + context.getContextId()));
    }

    public void setAllWatcherActivity(boolean active) {
        for (ToolIntegrationFileWatcher current : this.watchers.values()) {
            current.setWatcherActive(active);
        }
    }

    public void unregister(String previousToolName, ToolIntegrationContext integrationContext) {
        if (this.watchers.get(integrationContext) != null) {
            File path = new File(new File(integrationContext.getRootPathToToolIntegrationDirectory(), integrationContext.getNameOfToolIntegrationDirectory()), previousToolName);
            try {
                this.watchers.get(integrationContext).unregisterRecursive(FileSystems.getDefault().getPath(path.getAbsolutePath(), new String[0]));
            }
            catch (IOException e) {
                LOGGER.debug((Object)("Could not unregister tool directory of tool " + previousToolName), (Throwable)e);
            }
        }
    }

    public void registerRecursive(String toolName, ToolIntegrationContext integrationContext) {
        if (this.watchers.get(integrationContext) != null) {
            File path = new File(new File(integrationContext.getRootPathToToolIntegrationDirectory(), integrationContext.getNameOfToolIntegrationDirectory()), toolName);
            try {
                this.watchers.get(integrationContext).registerRecursive(FileSystems.getDefault().getPath(path.getAbsolutePath(), new String[0]));
            }
            catch (IOException e) {
                LOGGER.debug((Object)("Could not register tool directory of tool " + toolName), (Throwable)e);
            }
        }
    }

    public void shutdown() {
        LOGGER.debug((Object)"Shutting down file watcher.");
        for (ToolIntegrationContext context : this.watchers.keySet()) {
            this.unregisterRootDirectory(context);
        }
    }
}

