/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.integration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rcenvironment.core.component.datamanagement.api.CommonComponentHistoryDataItem;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class IntegrationHistoryDataItem
extends CommonComponentHistoryDataItem {
    protected static final String WORKING_DIRECTORY = "workingDirectory";
    protected static final String FORMAT_VERSION_1 = "1";
    protected static final String CURRENT_FORMAT_VERSION = "1";
    private static final long serialVersionUID = 266418465982554055L;
    protected String workingDirectory;
    private String identifier;

    public IntegrationHistoryDataItem(String identifier) {
        this.identifier = identifier;
    }

    public String getFormatVersion() {
        return StringUtils.escapeAndConcat((String[])new String[]{super.getFormatVersion(), "1"});
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String serialize(TypedDatumSerializer serializer) throws IOException {
        JsonNode rootNode;
        String commonDataString = super.serialize(serializer);
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        try {
            rootNode = mapper.readTree(commonDataString);
            ((ObjectNode)rootNode).put(WORKING_DIRECTORY, this.workingDirectory);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
        return rootNode.toString();
    }

    public static IntegrationHistoryDataItem fromString(String historyData, TypedDatumSerializer serializer, String identifier) throws IOException {
        IntegrationHistoryDataItem historyDataItem = new IntegrationHistoryDataItem(identifier);
        CommonComponentHistoryDataItem.initializeCommonHistoryDataFromString((CommonComponentHistoryDataItem)historyDataItem, (String)historyData, (TypedDatumSerializer)serializer);
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        try {
            Map tree = (Map)mapper.readValue(historyData, new HashMap().getClass());
            if (tree.get(WORKING_DIRECTORY) != null) {
                historyDataItem.setWorkingDirectory((String)tree.get(WORKING_DIRECTORY));
            }
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
        return historyDataItem;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setWorkingDirectory(String absolutePath) {
        this.workingDirectory = absolutePath;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }
}

