/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.protocol;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.SerializationException;
import de.rcenvironment.core.communication.model.NetworkRequest;
import de.rcenvironment.core.communication.model.NetworkResponse;
import de.rcenvironment.core.communication.model.impl.NetworkResponseImpl;
import de.rcenvironment.core.communication.protocol.NetworkRequestFactory;
import de.rcenvironment.core.communication.protocol.ProtocolConstants;
import de.rcenvironment.core.communication.utils.MessageUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.Serializable;
import org.apache.commons.logging.LogFactory;

public final class NetworkResponseFactory {
    private NetworkResponseFactory() {
    }

    public static NetworkResponse generateSuccessResponse(NetworkRequest request, byte[] responseBody) {
        return new NetworkResponseImpl(responseBody, request.getRequestId(), ProtocolConstants.ResultCode.SUCCESS);
    }

    public static NetworkResponse generateSuccessResponse(NetworkRequest request, Serializable responseBody) throws SerializationException {
        byte[] contentBytes = MessageUtils.serializeObject(responseBody);
        return new NetworkResponseImpl(contentBytes, request.getRequestId(), ProtocolConstants.ResultCode.SUCCESS);
    }

    public static NetworkResponse generateResponseWithResultCode(NetworkRequest request, byte[] responseBody, int resultCode) {
        ProtocolConstants.ResultCode resultCodeEnum = ProtocolConstants.ResultCode.fromCode(resultCode);
        return new NetworkResponseImpl(responseBody, request.getRequestId(), resultCodeEnum);
    }

    public static NetworkResponse generateResponseForNoRouteWhileForwarding(NetworkRequest request, InstanceNodeSessionId localNodeId) {
        return NetworkResponseFactory.generateErrorResponse(request, ProtocolConstants.ResultCode.NO_ROUTE_TO_DESTINATION_WHILE_FORWARDING, localNodeId, null);
    }

    public static NetworkResponse generateResponseForNoRouteAtSender(NetworkRequest request, InstanceNodeSessionId localNodeId) {
        return NetworkResponseFactory.generateErrorResponse(request, ProtocolConstants.ResultCode.NO_ROUTE_TO_DESTINATION_AT_SENDER, localNodeId, null);
    }

    public static NetworkResponse generateResponseForInternalErrorAtRecipient(NetworkRequest request, String errorId) {
        return NetworkResponseFactory.generateErrorResponse(request, ProtocolConstants.ResultCode.EXCEPTION_AT_DESTINATION, request.accessMetaData().getFinalRecipient(), errorId);
    }

    public static NetworkResponse generateResponseForErrorDuringDelivery(NetworkRequest request, InstanceNodeSessionId eventNodeId, String errorId) {
        return NetworkResponseFactory.generateErrorResponse(request, ProtocolConstants.ResultCode.EXCEPTION_DURING_DELIVERY, eventNodeId, errorId);
    }

    public static NetworkResponse generateResponseForCloseOrBrokenChannelDuringRequestDelivery(NetworkRequest request, InstanceNodeSessionId eventNodeId, String errorId) {
        return NetworkResponseFactory.generateErrorResponse(request, ProtocolConstants.ResultCode.CHANNEL_CLOSED_OR_BROKEN_BEFORE_SENDING_REQUEST, eventNodeId, errorId);
    }

    public static NetworkResponse generateResponseForChannelCloseWhileWaitingForResponse(NetworkRequest request, InstanceNodeSessionId eventNodeId, String errorId) {
        return NetworkResponseFactory.generateErrorResponse(request, ProtocolConstants.ResultCode.CHANNEL_OR_RESPONSE_LISTENER_SHUT_DOWN_WHILE_WAITING_FOR_RESPONSE, eventNodeId, errorId);
    }

    public static NetworkResponse generateResponseForTimeoutWaitingForResponse(NetworkRequest request, InstanceNodeSessionId eventNodeId) {
        return NetworkResponseFactory.generateErrorResponse(request, ProtocolConstants.ResultCode.TIMEOUT_WAITING_FOR_RESPONSE, eventNodeId, null);
    }

    private static NetworkResponse generateErrorResponse(NetworkRequest request, ProtocolConstants.ResultCode resultCode, InstanceNodeSessionId reporterNodeId, String errorId) {
        String nodeIdString;
        errorId = StringUtils.nullSafe((String)errorId);
        if (reporterNodeId != null) {
            nodeIdString = StringUtils.nullSafe((String)reporterNodeId.getInstanceNodeSessionIdString());
        } else {
            nodeIdString = "<null>";
            LogFactory.getLog(NetworkRequestFactory.class).warn((Object)"Observed <null> reporterNodeId");
        }
        String errorInfoPayload = StringUtils.escapeAndConcat((String[])new String[]{errorId, nodeIdString});
        return new NetworkResponseImpl(MessageUtils.serializeSafeObject((Serializable)((Object)errorInfoPayload)), request.getRequestId(), resultCode);
    }

    private static String representErrorLocationAsString(InstanceNodeSessionId localNodeId) {
        return localNodeId.toString();
    }
}

