/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.model.internal;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.NetworkGraphLink;
import de.rcenvironment.core.communication.common.NetworkGraphWithProperties;
import de.rcenvironment.core.communication.model.NetworkRoutingInformation;
import de.rcenvironment.core.communication.model.internal.NetworkGraphLinkImpl;
import de.rcenvironment.core.communication.model.internal.NetworkGraphNodeImpl;
import de.rcenvironment.core.communication.model.internal.NetworkRoutingInformationImpl;
import edu.uci.ics.jung.algorithms.filters.FilterUtils;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.LogFactory;

public class NetworkGraphImpl
implements NetworkGraphWithProperties {
    private final InstanceNodeSessionId localNodeId;
    private final Map<InstanceNodeSessionId, NetworkGraphNodeImpl> nodeMap = new HashMap<InstanceNodeSessionId, NetworkGraphNodeImpl>();
    private final DirectedSparseMultigraph<InstanceNodeSessionId, NetworkGraphLinkImpl> jungGraph;
    private NetworkRoutingInformation routingInformation;
    private String compactRepresentation;

    public NetworkGraphImpl(InstanceNodeSessionId localNodeId) {
        if (localNodeId == null) {
            throw new NullPointerException();
        }
        this.localNodeId = localNodeId;
        this.jungGraph = new DirectedSparseMultigraph();
        this.addNode(localNodeId);
    }

    private NetworkGraphImpl(NetworkGraphImpl sourceGraph, Set<InstanceNodeSessionId> subgraphVertices) {
        this.localNodeId = sourceGraph.localNodeId;
        this.jungGraph = (DirectedSparseMultigraph)FilterUtils.createInducedSubgraph(subgraphVertices, sourceGraph.jungGraph);
        if (!this.jungGraph.containsVertex((Object)this.localNodeId)) {
            throw new IllegalStateException();
        }
    }

    private NetworkGraphImpl(NetworkGraphImpl sourceGraph, Map<InstanceNodeSessionId, Map<String, String>> nodeProperties) {
        this.localNodeId = sourceGraph.localNodeId;
        this.jungGraph = sourceGraph.jungGraph;
        for (InstanceNodeSessionId nodeId : this.getNodeIds()) {
            NetworkGraphNodeImpl node = new NetworkGraphNodeImpl(nodeId, nodeProperties.get(nodeId));
            if (nodeId.equals(this.localNodeId)) {
                node.setIsLocalNode(true);
            }
            this.nodeMap.put(nodeId, node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNodeCount() {
        DirectedSparseMultigraph<InstanceNodeSessionId, NetworkGraphLinkImpl> directedSparseMultigraph = this.jungGraph;
        synchronized (directedSparseMultigraph) {
            return this.jungGraph.getVertexCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<InstanceNodeSessionId> getNodeIds() {
        DirectedSparseMultigraph<InstanceNodeSessionId, NetworkGraphLinkImpl> directedSparseMultigraph = this.jungGraph;
        synchronized (directedSparseMultigraph) {
            return new HashSet<InstanceNodeSessionId>(this.jungGraph.getVertices());
        }
    }

    public Collection<NetworkGraphNodeImpl> getNodes() {
        return Collections.unmodifiableCollection(this.nodeMap.values());
    }

    @Override
    public NetworkGraphNodeImpl getNodeById(InstanceNodeSessionId nodeId) {
        return this.nodeMap.get(nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLinkCount() {
        DirectedSparseMultigraph<InstanceNodeSessionId, NetworkGraphLinkImpl> directedSparseMultigraph = this.jungGraph;
        synchronized (directedSparseMultigraph) {
            return this.jungGraph.getEdgeCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<? extends NetworkGraphLink> getLinks() {
        DirectedSparseMultigraph<InstanceNodeSessionId, NetworkGraphLinkImpl> directedSparseMultigraph = this.jungGraph;
        synchronized (directedSparseMultigraph) {
            return new HashSet(this.jungGraph.getEdges());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsLinkBetween(InstanceNodeSessionId sourceNodeId, InstanceNodeSessionId targetNodeId) {
        Collection outEdges;
        DirectedSparseMultigraph<InstanceNodeSessionId, NetworkGraphLinkImpl> directedSparseMultigraph = this.jungGraph;
        synchronized (directedSparseMultigraph) {
            outEdges = this.jungGraph.getOutEdges((Object)sourceNodeId);
        }
        for (NetworkGraphLinkImpl edge : outEdges) {
            if (!edge.getTargetNodeId().equals(targetNodeId)) continue;
            return true;
        }
        return false;
    }

    public NetworkGraphImpl reduceToReachableGraph() {
        this.generateRoutingInformation();
        NetworkGraphImpl reachableGraph = new NetworkGraphImpl(this, this.routingInformation.getReachableNodes());
        reachableGraph.setRoutingInformation(this.routingInformation);
        return reachableGraph;
    }

    @Override
    public NetworkGraphWithProperties attachNodeProperties(Map<InstanceNodeSessionId, Map<String, String>> nodeProperties) {
        return new NetworkGraphImpl(this, nodeProperties);
    }

    public NetworkRoutingInformation generateRoutingInformation() {
        if (this.routingInformation != null) {
            throw new IllegalStateException("Not expected to be called twice");
        }
        this.routingInformation = new NetworkRoutingInformationImpl(this);
        return this.routingInformation;
    }

    @Override
    public NetworkRoutingInformation getRoutingInformation() {
        return this.routingInformation;
    }

    @Override
    public synchronized String getCompactRepresentation() {
        if (this.compactRepresentation == null) {
            this.compactRepresentation = this.generateCompactRepresentation();
        }
        return this.compactRepresentation;
    }

    private String generateCompactRepresentation() {
        StringBuilder buffer = new StringBuilder();
        TreeSet<InstanceNodeSessionId> sortedNodes = new TreeSet<InstanceNodeSessionId>(new Comparator<InstanceNodeSessionId>(){

            @Override
            public int compare(InstanceNodeSessionId o1, InstanceNodeSessionId o2) {
                return o1.getInstanceNodeSessionIdString().compareTo(o2.getInstanceNodeSessionIdString());
            }
        });
        Set<InstanceNodeSessionId> unsortedNodes = this.getNodeIds();
        sortedNodes.addAll(unsortedNodes);
        if (unsortedNodes.size() != sortedNodes.size()) {
            throw new IllegalStateException();
        }
        buffer.append("Nodes: ");
        for (InstanceNodeSessionId node : sortedNodes) {
            buffer.append(node.getInstanceNodeSessionIdString());
            buffer.append(" ");
        }
        TreeSet<NetworkGraphLink> sortedLinks = new TreeSet<NetworkGraphLink>(new Comparator<NetworkGraphLink>(){

            @Override
            public int compare(NetworkGraphLink o1, NetworkGraphLink o2) {
                return o1.getLinkId().compareTo(o2.getLinkId());
            }
        });
        Collection<? extends NetworkGraphLink> unsortedLinks = this.getLinks();
        sortedLinks.addAll(unsortedLinks);
        if (unsortedLinks.size() != sortedLinks.size()) {
            throw new IllegalStateException();
        }
        buffer.append("Links: ");
        for (NetworkGraphLink link : sortedLinks) {
            buffer.append(link.getLinkId());
            buffer.append(":");
            buffer.append(link.getSourceNodeId().getInstanceNodeSessionIdString());
            buffer.append(">");
            buffer.append(link.getTargetNodeId().getInstanceNodeSessionIdString());
            buffer.append(" ");
        }
        buffer.append("\n");
        String c = buffer.toString();
        return c;
    }

    @Override
    public InstanceNodeSessionId getLocalNodeId() {
        return this.localNodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(InstanceNodeSessionId nodeId) {
        DirectedSparseMultigraph<InstanceNodeSessionId, NetworkGraphLinkImpl> directedSparseMultigraph = this.jungGraph;
        synchronized (directedSparseMultigraph) {
            if (this.jungGraph.containsVertex((Object)nodeId)) {
                if (!nodeId.equals(this.localNodeId)) {
                    LogFactory.getLog(this.getClass()).warn((Object)("Existing node added again: " + nodeId));
                }
                return;
            }
            this.jungGraph.addVertex((Object)nodeId);
        }
    }

    public void addLink(String linkId, InstanceNodeSessionId source, InstanceNodeSessionId target) {
        this.addLink(new NetworkGraphLinkImpl(linkId, source, target));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLink(NetworkGraphLinkImpl link) {
        DirectedSparseMultigraph<InstanceNodeSessionId, NetworkGraphLinkImpl> directedSparseMultigraph = this.jungGraph;
        synchronized (directedSparseMultigraph) {
            this.jungGraph.addEdge((Object)link, (Object)link.getSourceNodeId(), (Object)link.getTargetNodeId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DirectedSparseMultigraph<InstanceNodeSessionId, NetworkGraphLinkImpl> getJungGraph() {
        DirectedSparseMultigraph<InstanceNodeSessionId, NetworkGraphLinkImpl> directedSparseMultigraph = this.jungGraph;
        synchronized (directedSparseMultigraph) {
            return this.jungGraph;
        }
    }

    private void setRoutingInformation(NetworkRoutingInformation routingInformation) {
        this.routingInformation = routingInformation;
    }
}

