/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.fileaccess.api;

import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.fileaccess.api.RemoteFileConnection;
import de.rcenvironment.core.communication.fileaccess.internal.RemoteFileConnectionSupport;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.Assertions;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;

public class RemoteInputStream
extends InputStream
implements Serializable {
    private static final long serialVersionUID = 8592687526532347895L;
    private static final String ERROR_PARAMETERS_NULL = "The parameter \"%s\" must not be null.";
    private static final String REMOTE_STREAMS_SHOULD_NOT_CALL_THIS_METHOD = "Remote streams should not call this method";
    private final RemoteFileConnection remoteFileConnection;

    public RemoteInputStream(URI uri) throws IOException {
        Assertions.isDefined((Object)uri, (String)StringUtils.format((String)ERROR_PARAMETERS_NULL, (Object[])new Object[]{"uri"}));
        Assertions.isDefined((Object)uri, (String)StringUtils.format((String)ERROR_PARAMETERS_NULL, (Object[])new Object[]{"certificate"}));
        try {
            this.remoteFileConnection = RemoteFileConnectionSupport.getRemoteFileConnection(uri);
        }
        catch (CommunicationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.remoteFileConnection.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read() throws IOException {
        throw new UnsupportedOperationException(REMOTE_STREAMS_SHOULD_NOT_CALL_THIS_METHOD);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.remoteFileConnection.skip(n);
    }

    @Override
    public void close() throws IOException {
        this.remoteFileConnection.close();
    }
}

