/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.configuration;

import de.rcenvironment.core.communication.sshconnection.InitialSshConnectionConfig;
import de.rcenvironment.core.configuration.ConfigurationSegment;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshConnectionsConfiguration {
    private List<InitialSshConnectionConfig> providedConnectionConfigs = new ArrayList<InitialSshConnectionConfig>();
    private final Log log = LogFactory.getLog(this.getClass());

    public SshConnectionsConfiguration() {
    }

    public SshConnectionsConfiguration(ConfigurationSegment configuration) {
        Map connectionElements = configuration.listElements("sshConnections");
        if (connectionElements != null) {
            for (Map.Entry entry : connectionElements.entrySet()) {
                ConfigurationSegment configPart = (ConfigurationSegment)entry.getValue();
                String id = (String)entry.getKey();
                try {
                    InitialSshConnectionConfig connection = this.parseConnectionEntry(configPart);
                    connection.setId(id);
                    this.providedConnectionConfigs.add(connection);
                }
                catch (ConfigurationException e) {
                    this.log.error((Object)("Error in connection entry " + (String)entry.getKey()), (Throwable)e);
                }
            }
        }
    }

    private InitialSshConnectionConfig parseConnectionEntry(ConfigurationSegment connectionPart) throws ConfigurationException {
        InitialSshConnectionConfig connection = new InitialSshConnectionConfig();
        connection.setHost(connectionPart.getString("host"));
        connection.setPort(connectionPart.getLong("port").intValue());
        connection.setUser(connectionPart.getString("loginName"));
        connection.setDisplayName(connectionPart.getString("displayName"));
        connection.setKeyFileLocation(connectionPart.getString("keyfileLocation"));
        connection.setUsePassphrase(connectionPart.getBoolean("noPassphrase", Boolean.valueOf(false)) == false);
        return connection;
    }

    public List<InitialSshConnectionConfig> getProvidedConnectionConfigs() {
        return this.providedConnectionConfigs;
    }
}

