/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.command.internal.handlers;

import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.CommandContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Dictionary;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class EquinoxConsoleCommandInvoker {
    private static final String MSG_ERROR_INVOKING_OSGI_COMMAND = "Error invoking OSGi command";
    private final Log log = LogFactory.getLog(this.getClass());

    public void execute(CommandContext context) throws CommandException {
        ServiceReference[] refs;
        CommandInterpreter commandInterpreter = EquinoxConsoleCommandInvoker.createCommandInterpreter(context);
        String osgiCommand = context.consumeNextToken();
        if (osgiCommand == null || osgiCommand.isEmpty()) {
            throw CommandException.syntaxError("Missing OSGi command", context);
        }
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        try {
            refs = bundleContext.getAllServiceReferences(CommandProvider.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            this.log.error((Object)"Error getting service references", (Throwable)e);
            context.println("Internal error");
            return;
        }
        String commandMethodName = "_" + osgiCommand;
        boolean matched = false;
        ServiceReference[] serviceReferenceArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            Method[] methods;
            ServiceReference ref = serviceReferenceArray[n2];
            CommandProvider service = (CommandProvider)bundleContext.getService(ref);
            Method[] methodArray = methods = service.getClass().getMethods();
            int n3 = methods.length;
            int n4 = 0;
            while (n4 < n3) {
                Method method = methodArray[n4];
                if (method.getName().equals(commandMethodName)) {
                    this.invokeServiceMethod(service, method, commandInterpreter);
                    matched = true;
                }
                ++n4;
            }
            bundleContext.ungetService(ref);
            ++n2;
        }
        if (!matched) {
            context.println("No matching OSGi command found. (Note that built-in commands like \"info\" or \"help\" may not be accessible.)");
        }
    }

    private void invokeServiceMethod(CommandProvider service, Method method, CommandInterpreter commandInterpreter) {
        try {
            method.invoke((Object)service, commandInterpreter);
        }
        catch (RuntimeException e) {
            this.log.error((Object)MSG_ERROR_INVOKING_OSGI_COMMAND, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.log.error((Object)MSG_ERROR_INVOKING_OSGI_COMMAND, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            this.log.error((Object)MSG_ERROR_INVOKING_OSGI_COMMAND, (Throwable)e);
        }
    }

    private static CommandInterpreter createCommandInterpreter(final CommandContext context) {
        return new CommandInterpreter(){
            private StringBuilder lineBuffer;

            public void print(Object arg0) {
                if (this.lineBuffer == null) {
                    this.lineBuffer = new StringBuilder();
                }
                this.lineBuffer.append(arg0.toString());
            }

            public void println(Object arg0) {
                if (this.lineBuffer != null) {
                    this.lineBuffer.append(arg0.toString());
                    context.println(this.lineBuffer.toString());
                    this.lineBuffer = null;
                } else {
                    context.println(arg0);
                }
            }

            public void println() {
                this.println("");
            }

            public void printStackTrace(Throwable arg0) {
                LogFactory.getLog(this.getClass()).warn((Object)("Unhandled printStackTrace output: " + arg0));
            }

            public void printDictionary(Dictionary arg0, String arg1) {
                LogFactory.getLog(this.getClass()).warn((Object)("Unhandled printDictionary output: " + arg1));
            }

            public void printBundleResource(Bundle arg0, String arg1) {
                LogFactory.getLog(this.getClass()).warn((Object)("Unhandled printBundleResource output: " + arg1));
            }

            public String nextArgument() {
                return context.consumeNextToken();
            }

            public Object execute(String arg0) {
                return null;
            }
        };
    }
}

