/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.command.internal;

import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandDescription;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.command.spi.SingleCommandHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.LogFactory;

public class CommandPluginDispatcher
implements SingleCommandHandler {
    private Map<String, CommandPlugin> pluginsByTopLevelCommand = new HashMap<String, CommandPlugin>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CommandContext context) throws CommandException {
        if (context.consumeNextTokenIfEquals("explain")) {
            context.println("Parsed command tokens: " + context.consumeRemainingTokens());
            return;
        }
        CommandPlugin plugin = null;
        String topLevelCommand = context.peekNextToken();
        Map<String, CommandPlugin> map = this.pluginsByTopLevelCommand;
        synchronized (map) {
            if (topLevelCommand == null) {
                throw new IllegalArgumentException("Empty command");
            }
            plugin = this.pluginsByTopLevelCommand.get(topLevelCommand);
        }
        if (plugin != null) {
            try {
                plugin.execute(context);
            }
            catch (RuntimeException e) {
                LogFactory.getLog(this.getClass()).error((Object)"Uncaught exception in command handler", (Throwable)e);
                throw CommandException.executionError("Uncaught exception in command handler: " + e.toString(), context);
            }
        } else {
            throw CommandException.unknownCommand(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPlugin(CommandPlugin plugin) {
        Set<String> topLevelCommands = this.determineTopLevelCommands(plugin);
        Map<String, CommandPlugin> map = this.pluginsByTopLevelCommand;
        synchronized (map) {
            for (String command : topLevelCommands) {
                if (this.pluginsByTopLevelCommand.get(command) != null) {
                    LogFactory.getLog(this.getClass()).warn((Object)("Ignoring new command plugin registration as another plugin already handles the command " + command));
                    continue;
                }
                this.pluginsByTopLevelCommand.put(command, plugin);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPlugin(CommandPlugin plugin) {
        Set<String> topLevelCommands = this.determineTopLevelCommands(plugin);
        Map<String, CommandPlugin> map = this.pluginsByTopLevelCommand;
        synchronized (map) {
            for (String command : topLevelCommands) {
                if (this.pluginsByTopLevelCommand.get(command) != plugin) {
                    LogFactory.getLog(this.getClass()).warn((Object)("Another plugin is handling the command " + command));
                    continue;
                }
                this.pluginsByTopLevelCommand.remove(command);
            }
        }
    }

    private Set<String> determineTopLevelCommands(CommandPlugin plugin) {
        HashSet<String> topLevelCommands = new HashSet<String>();
        for (CommandDescription cd : plugin.getCommandDescriptions()) {
            String[] tlcs;
            String[] staticPartSegments = cd.getStaticPart().split(" ");
            String[] stringArray = tlcs = staticPartSegments[0].split("/");
            int n = tlcs.length;
            int n2 = 0;
            while (n2 < n) {
                String tlc = stringArray[n2];
                topLevelCommands.add(tlc);
                ++n2;
            }
        }
        return topLevelCommands;
    }
}

