/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.xml.merger.gui;

import de.rcenvironment.core.component.api.ComponentUtils;
import de.rcenvironment.core.component.datamanagement.api.CommonComponentHistoryDataItem;
import de.rcenvironment.core.component.xml.XmlComponentHistoryDataItem;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.gui.datamanagement.browser.spi.CommonHistoryDataItemSubtreeBuilderUtils;
import de.rcenvironment.core.gui.datamanagement.browser.spi.ComponentHistoryDataItemSubtreeBuilder;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNode;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNodeType;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class XmlMergerHistoryDataItemSubtreeBuilder
implements ComponentHistoryDataItemSubtreeBuilder {
    private static final Image COMPONENT_ICON;

    static {
        String bundleName = "de.rcenvironment.components.xml.merger.common";
        String iconName = "xmlMerger16.png";
        URL url = ComponentUtils.readIconURL((String)bundleName, (String)iconName);
        COMPONENT_ICON = url != null ? ImageDescriptor.createFromURL((URL)url).createImage() : null;
    }

    public String[] getSupportedHistoryDataItemIdentifier() {
        return new String[]{"de.rcenvironment.xmlmerger"};
    }

    public Serializable deserializeHistoryDataItem(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        return (Serializable)ois.readObject();
    }

    public void buildInitialHistoryDataItemSubtree(Serializable historyDataItem, DMBrowserNode parent) {
        ServiceRegistryAccess registryAccess = ServiceRegistry.createAccessFor((Object)this);
        TypedDatumSerializer serializer = ((TypedDatumService)registryAccess.getService(TypedDatumService.class)).getSerializer();
        if (historyDataItem instanceof String) {
            XmlComponentHistoryDataItem historyData;
            try {
                historyData = XmlComponentHistoryDataItem.fromString((String)((String)((Object)historyDataItem)), (TypedDatumSerializer)serializer, (String)"de.rcenvironment.xmlmerger");
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            CommonHistoryDataItemSubtreeBuilderUtils.buildCommonHistoryDataItemSubtrees((CommonComponentHistoryDataItem)historyData, (DMBrowserNode)parent);
            if (historyData.getXmlWithVariablesFileReference() != null) {
                DMBrowserNode mappingWithVariablesNode = DMBrowserNode.addNewChildNode((String)"Mapping with variables", (DMBrowserNodeType)DMBrowserNodeType.InformationText, (DMBrowserNode)parent);
                DMBrowserNode xmlWithVariablesFileNode = DMBrowserNode.addNewLeafNode((String)"xmlWithVariables.xml", (DMBrowserNodeType)DMBrowserNodeType.DMFileResource, (DMBrowserNode)mappingWithVariablesNode);
                xmlWithVariablesFileNode.setAssociatedFilename("xmlWithVariables.xml");
                xmlWithVariablesFileNode.setDataReferenceId(historyData.getXmlWithVariablesFileReference());
            }
        } else {
            throw new IllegalArgumentException(StringUtils.format((String)"Parsing history data point failed: Expected type %s, but was type %s", (Object[])new Object[]{String.class.getCanonicalName(), historyDataItem.getClass().getCanonicalName()}));
        }
    }

    public Image getComponentIcon(String identifier) {
        return COMPONENT_ICON;
    }
}

