/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.outputwriter.gui;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.components.outputwriter.common.OutputLocation;
import de.rcenvironment.components.outputwriter.common.OutputLocationList;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.LogFactory;

public class RemoveOutputLocationsCommand
extends WorkflowNodeCommand {
    private List<String> identifiers;
    private ObjectMapper mapper;
    private boolean executable = true;
    private Refreshable[] refreshable;
    private boolean undoable = false;
    private String oldJsonString;
    private List<OutputLocation> oldLocations;

    public RemoveOutputLocationsCommand(List<String> ids, Refreshable ... refreshable) {
        this.identifiers = ids;
        this.refreshable = refreshable;
        this.mapper = JsonUtils.getDefaultObjectMapper();
        this.mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
    }

    public RemoveOutputLocationsCommand(String id, Refreshable ... refreshable) {
        this.identifiers = new ArrayList<String>();
        this.identifiers.add(id);
        this.refreshable = refreshable;
        this.mapper = JsonUtils.getDefaultObjectMapper();
        this.mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
    }

    public void initialize() {
    }

    public boolean canExecute() {
        return this.executable;
    }

    public boolean canUndo() {
        return this.undoable;
    }

    public void execute() {
        try {
            String inputJsonString = this.getProperties().getConfigurationDescription().getConfigurationValue("outputLocations");
            OutputLocationList list = (OutputLocationList)this.mapper.readValue(inputJsonString, OutputLocationList.class);
            this.oldLocations = new ArrayList<OutputLocation>();
            for (String id : this.identifiers) {
                for (String inputName : list.getOutputLocationById(id).getInputs()) {
                    this.oldLocations.add(list.getOutputLocationById(id));
                    EndpointDescription oldDesc = this.getProperties().getInputDescriptionsManager().getEndpointDescription(inputName);
                    if (oldDesc == null) continue;
                    this.getProperties().getInputDescriptionsManager().editDynamicEndpointDescription(inputName, inputName, oldDesc.getDataType(), oldDesc.getMetaData(), oldDesc.getDynamicEndpointIdentifier(), "write");
                }
                this.getProperties().getInputDescriptionsManager().removeDynamicEndpointGroupDescription(list.getOutputLocationById(id).getGroupId());
                list.removeLocation(id);
            }
            String outputJsonString = this.mapper.writeValueAsString((Object)list);
            this.getProperties().getConfigurationDescription().setConfigurationValue("outputLocations", outputJsonString);
            this.oldJsonString = inputJsonString;
            this.executable = false;
            this.undoable = true;
            if (this.refreshable != null) {
                Refreshable[] refreshableArray = this.refreshable;
                int n = this.refreshable.length;
                int n2 = 0;
                while (n2 < n) {
                    Refreshable r = refreshableArray[n2];
                    r.refresh();
                    ++n2;
                }
            }
        }
        catch (IOException e) {
            LogFactory.getLog(((Object)((Object)this)).getClass()).debug((Object)("Error when writing components to JSON: " + e.getMessage()));
        }
    }

    public void undo() {
        this.getProperties().getConfigurationDescription().setConfigurationValue("outputLocations", this.oldJsonString);
        for (OutputLocation out : this.oldLocations) {
            if (this.getProperties().getInputDescriptionsManager().isValidEndpointGroupName(out.getGroupId())) {
                this.getProperties().getInputDescriptionsManager().addDynamicEndpointGroupDescription("dynamicAndGroup", out.getGroupId());
            }
            for (String inputName : out.getInputs()) {
                EndpointDescription oldDesc = this.getProperties().getInputDescriptionsManager().getEndpointDescription(inputName);
                if (oldDesc == null) continue;
                this.getProperties().getInputDescriptionsManager().editDynamicEndpointDescription(inputName, inputName, oldDesc.getDataType(), oldDesc.getMetaData(), oldDesc.getDynamicEndpointIdentifier(), out.getGroupId());
            }
        }
        this.executable = true;
        this.undoable = false;
        if (this.refreshable != null) {
            Refreshable[] refreshableArray = this.refreshable;
            int n = this.refreshable.length;
            int n2 = 0;
            while (n2 < n) {
                Object r = refreshableArray[n2];
                r.refresh();
                ++n2;
            }
        }
    }
}

