/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.optimizer.execution.algorithms.registry.internal;

import de.rcenvironment.components.optimizer.common.MethodDescription;
import de.rcenvironment.components.optimizer.common.execution.OptimizerAlgorithmExecutor;
import de.rcenvironment.components.optimizer.execution.algorithms.registry.OptimizerAlgorithmExecutorFactory;
import de.rcenvironment.components.optimizer.execution.algorithms.registry.OptimizerAlgorithmExecutorFactoryRegistry;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class OptimizerAlgorithmExecutorFactoryRegistryImpl
implements OptimizerAlgorithmExecutorFactoryRegistry {
    private final List<OptimizerAlgorithmExecutorFactory> factories = Collections.synchronizedList(new LinkedList());

    @Override
    public void addOptimizerAlgorithmExecutorFactory(OptimizerAlgorithmExecutorFactory incProvider) {
        if (incProvider != null && !this.factories.contains(incProvider)) {
            this.factories.add(incProvider);
        }
    }

    @Override
    public void removeOptimizerAlgorithmExecutorFactory(OptimizerAlgorithmExecutorFactory algFactory) {
        if (algFactory != null && this.factories.contains(algFactory)) {
            this.factories.remove(algFactory);
        }
    }

    @Override
    public OptimizerAlgorithmExecutor createAlgorithmProviderInstance(String algorithmPackage, Map<String, MethodDescription> methodConfiguration, Map<String, TypedDatum> outputValues, Collection<String> input, ComponentContext compContext, Map<String, Map<String, Double>> boundMaps, Map<String, Double> stepValues) throws ComponentException {
        OptimizerAlgorithmExecutor result = null;
        for (OptimizerAlgorithmExecutorFactory currentProvider : this.factories) {
            if (!currentProvider.getOptimizerAlgorithmPackageIdentifier().equalsIgnoreCase(algorithmPackage)) continue;
            result = currentProvider.createOptimizerAlgorithmExecutorInstance(methodConfiguration, outputValues, input, compContext, boundMaps.get("upper"), boundMaps.get("lower"), stepValues);
        }
        return result;
    }
}

