/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.cpacs.vampzeroinitializer.gui;

import de.rcenvironment.components.cpacs.vampzeroinitializer.gui.AbstractSwtHelper;
import de.rcenvironment.components.cpacs.vampzeroinitializer.gui.model.Component;
import de.rcenvironment.components.cpacs.vampzeroinitializer.gui.model.Discipline;
import de.rcenvironment.components.cpacs.vampzeroinitializer.gui.model.Parameter;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class ParameterCompositeWrapper {
    private static final int NUMBER_140 = 140;
    private static final int NUMBER60 = 60;
    private static final int NUMBER100 = 100;
    private static final int NUMBER120 = 120;
    private static final int NUMBER150 = 150;
    private static final Log LOGGER = LogFactory.getLog(ParameterCompositeWrapper.class);
    private Composite inner;
    private TreeViewer viewer;
    private Discipline discipline;
    private List<Component> modifiedComponents;
    private org.eclipse.swt.widgets.List parameterList;
    private Text nameText;
    private Text descriptionText;
    private Text valueText;
    private Text factorText;
    private MouseListener textMarker = new MouseAdapter(){

        public void mouseDown(MouseEvent event) {
            ((Text)event.widget).setSelection(0, ((Text)event.widget).getText().length());
        }
    };

    public ParameterCompositeWrapper(AbstractSwtHelper factory, Composite parent, List<Component> modifiedComponents) {
        this.inner = factory.createComposite(parent);
        this.inner.setLayout(factory.createDefaultLayout(2));
        this.modifiedComponents = modifiedComponents;
        this.parameterList = new org.eclipse.swt.widgets.List(this.inner, 2564);
        this.parameterList.setLayoutData((Object)new TableWrapData(256, 256));
        ((TableWrapData)this.parameterList.getLayoutData()).maxHeight = 100;
        ((TableWrapData)this.parameterList.getLayoutData()).maxWidth = 150;
        ((TableWrapData)this.parameterList.getLayoutData()).grabHorizontal = true;
        ((TableWrapData)this.parameterList.getLayoutData()).grabVertical = true;
        Composite rightComposite = factory.createComposite(this.inner, 2, new int[0]);
        ((TableWrapData)rightComposite.getLayoutData()).grabHorizontal = true;
        factory.createLabel(rightComposite, "Name:", new int[0]);
        this.nameText = factory.createText(rightComposite, "", new int[0]);
        ((TableWrapData)this.nameText.getLayoutData()).maxWidth = 120;
        factory.createLabel(rightComposite, "Description:", new int[0]);
        this.descriptionText = factory.createText(rightComposite, "\n", new int[0]);
        ((TableWrapData)this.descriptionText.getLayoutData()).heightHint = 60;
        ((TableWrapData)this.descriptionText.getLayoutData()).grabHorizontal = true;
        ((TableWrapData)this.descriptionText.getLayoutData()).maxWidth = 120;
        factory.createLabel(rightComposite, "Value:", new int[0]);
        this.valueText = factory.createText(rightComposite, "0.0", new int[0]);
        this.valueText.addMouseListener(this.textMarker);
        factory.createLabel(rightComposite, "Factor:", new int[0]);
        this.factorText = factory.createText(rightComposite, "1.0", new int[0]);
        this.factorText.addMouseListener(this.textMarker);
        Label rightfiller1 = factory.createLabel(rightComposite, "", new int[0]);
        ((TableWrapData)rightfiller1.getLayoutData()).indent = 120;
        ((TableWrapData)rightfiller1.getLayoutData()).heightHint = 5;
        Label rightfiller2 = factory.createLabel(rightComposite, "", new int[0]);
        ((TableWrapData)rightfiller2.getLayoutData()).indent = 120;
        ((TableWrapData)rightfiller2.getLayoutData()).heightHint = 5;
        Button revertButton = factory.createButton(rightComposite, "Revert", new Listener(){

            public void handleEvent(Event event) {
                int index = ParameterCompositeWrapper.this.parameterList.getSelectionIndex();
                if (index >= 0 && index < ParameterCompositeWrapper.this.parameterList.getItemCount()) {
                    String selectedParameterName = ParameterCompositeWrapper.this.parameterList.getItem(index);
                    Parameter selectedParameter = ParameterCompositeWrapper.this.discipline.getParameterForName(selectedParameterName);
                    if (selectedParameter != null) {
                        ParameterCompositeWrapper.this.removeModifiedParameter(selectedParameter);
                    } else {
                        LOGGER.error((Object)"Parameter not found, but should have.");
                    }
                    ParameterCompositeWrapper.this.viewer.refresh();
                }
            }
        }, 128);
        revertButton.setImage(factory.undoImage);
        ((TableWrapData)revertButton.getLayoutData()).grabHorizontal = true;
        final Runnable applyAction = new Runnable(){

            @Override
            public void run() {
                int index = ParameterCompositeWrapper.this.parameterList.getSelectionIndex();
                if (index >= 0 && index < ParameterCompositeWrapper.this.parameterList.getItemCount()) {
                    String selectedParameterName = ParameterCompositeWrapper.this.parameterList.getItem(index);
                    Parameter selectedParameter = ParameterCompositeWrapper.this.discipline.getParameterForName(selectedParameterName);
                    if (selectedParameter != null) {
                        ParameterCompositeWrapper.this.addModifiedParameter(selectedParameter, ParameterCompositeWrapper.this.valueText.getText().trim(), ParameterCompositeWrapper.this.factorText.getText().trim());
                        ParameterCompositeWrapper.this.expandTo(selectedParameter);
                    } else {
                        LOGGER.error((Object)"Parameter not found, but should have.");
                    }
                }
            }
        };
        Button applyButton = factory.createButton(rightComposite, "Apply", new Listener(){

            public void handleEvent(Event event) {
                applyAction.run();
            }
        }, 128);
        applyButton.setImage(factory.okImage);
        ((TableWrapData)applyButton.getLayoutData()).grabHorizontal = true;
        KeyAdapter enterHit = new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\r') {
                    applyAction.run();
                }
            }
        };
        this.valueText.addKeyListener((KeyListener)enterHit);
        this.factorText.addKeyListener((KeyListener)enterHit);
        this.parameterList.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int index = ParameterCompositeWrapper.this.parameterList.getSelectionIndex();
                if (index >= 0 && index < ParameterCompositeWrapper.this.parameterList.getItemCount()) {
                    String selection = ParameterCompositeWrapper.this.parameterList.getSelection()[0];
                    Parameter parameter = ParameterCompositeWrapper.this.discipline.getParameterForName(selection);
                    if (parameter == null) {
                        LOGGER.error((Object)"Existing parameter not found. Fatal error!");
                    } else {
                        ParameterCompositeWrapper.this.setName(selection);
                        ParameterCompositeWrapper.this.setDescription(parameter.getDescription());
                        ParameterCompositeWrapper.this.setValue(parameter.getValue());
                        ParameterCompositeWrapper.this.setFactor(parameter.getFactor());
                        ParameterCompositeWrapper.this.redraw();
                    }
                }
            }
        });
        Label leftfiller = factory.createLabel(this.inner, "", new int[0]);
        ((TableWrapData)leftfiller.getLayoutData()).indent = 140;
        ((TableWrapData)leftfiller.getLayoutData()).heightHint = 0;
        ((TableWrapData)leftfiller.getLayoutData()).maxHeight = 0;
    }

    public void setViewer(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public void setDiscipline(Discipline discipline) {
        this.discipline = discipline;
        this.parameterList.removeAll();
        for (Parameter parameter : discipline.getParameters()) {
            this.parameterList.add(parameter.getName());
        }
    }

    public void setName(String text) {
        this.nameText.setText(text);
    }

    public void setDescription(String description) {
        this.descriptionText.setText(description);
        this.descriptionText.setToolTipText(description.replaceAll("\\s\\s+", "\n"));
    }

    public void setValue(String value) {
        this.valueText.setText(value);
    }

    public void setFactor(String factor) {
        this.factorText.setText(factor);
    }

    void removeModifiedParameter(Parameter parameter) {
        Discipline dis = this.getOrCreateModifiedDiscipline(parameter.getDiscipline(), false);
        if (dis == null) {
            return;
        }
        Parameter oldParameter = dis.getParameterForName(parameter.getName());
        if (oldParameter != null) {
            dis.getParameters().remove(oldParameter);
            if (dis.getParameters().size() == 0) {
                Component oldComponent = dis.getComponent();
                oldComponent.getDisciplines().remove(dis);
                if (oldComponent.getDisciplines().size() == 0) {
                    this.modifiedComponents.remove(oldComponent);
                }
            }
        }
    }

    private Discipline getOrCreateModifiedDiscipline(Discipline dis, boolean cr) {
        Component component = this.getOrCreateModifiedComponent(dis.getComponent(), cr);
        Discipline result = null;
        if (component != null) {
            Discipline d = component.getDisciplineForName(dis.getName());
            if (d != null) {
                result = d;
            } else {
                if (!cr) {
                    return null;
                }
                Discipline newDiscipline = (Discipline)new Discipline().setName(dis.getName());
                newDiscipline.setComponent(component);
                component.getDisciplines().add(newDiscipline);
                return newDiscipline;
            }
        }
        return result;
    }

    private Component getOrCreateModifiedComponent(Component component, boolean create) {
        for (Component c : this.modifiedComponents) {
            if (!c.getName().equals(component.getName())) continue;
            return c;
        }
        if (!create) {
            return null;
        }
        Component newComponent = (Component)new Component().setName(component.getName());
        this.modifiedComponents.add(newComponent);
        return newComponent;
    }

    void addModifiedParameter(Parameter parameter, String value, String factor) {
        Discipline dis = this.getOrCreateModifiedDiscipline(parameter.getDiscipline(), true);
        Parameter p = dis.getParameterForName(parameter.getName());
        if (p != null) {
            p.setValue(value).setFactor(factor);
            return;
        }
        Parameter newParameter = ((Parameter)new Parameter().setName(parameter.getName())).setDescription(parameter.getDescription()).setValue(value).setFactor(factor);
        newParameter.setDiscipline(dis);
        dis.getParameters().add(newParameter);
    }

    private void expandTo(Parameter parameter) {
        TreeItem root = this.viewer.getTree().getItem(0);
        this.revealNode(root);
        this.viewer.expandAll();
        String componentName = parameter.getDiscipline().getComponent().getName();
        int i = 0;
        int n = root.getItemCount();
        while (i < n) {
            TreeItem item = root.getItem(i);
            if (item.getText().equals(componentName)) {
                this.revealNode(item);
                String disciplineName = parameter.getDiscipline().getName();
                int j = 0;
                int o = item.getItemCount();
                while (j < o) {
                    TreeItem item2 = item.getItem(j);
                    if (item2.getText().equals(disciplineName)) {
                        this.revealNode(item2);
                        String parameterName = parameter.getName();
                        int k = 0;
                        int p = item2.getItemCount();
                        while (k < p) {
                            TreeItem item3 = item2.getItem(k);
                            if (item3.getText().equals(parameterName)) {
                                this.revealNode(item3);
                                return;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void revealNode(TreeItem node) {
        assert (node != null);
        node.setExpanded(true);
        this.viewer.getTree().update();
        this.viewer.getTree().showItem(node);
        this.viewer.refresh(true);
    }

    void redraw() {
        this.inner.pack(true);
        this.inner.getParent().getParent().redraw();
    }
}

