/*
 * Copyright (C) 2006-2016 DLR, Germany
 * 
 * All rights reserved
 * 
 * http://www.rcenvironment.de/
 */
 
package de.rcenvironment.core.gui.communication.views.contributors;

import org.eclipse.swt.widgets.Shell;


/**
 * Dialog for adding SSH connections via GUI.
 *
 * @author Brigitte Boden
 * @author Oliver Seebach
 */
public class AddSshConnectionDialog extends AbstractSshConnectionDialog {
    private static final String DIALOG_TITLE = "Add SSH Connection";
    private static final String HINT = "Note: The connection will not be saved.\n"
           + "To create permanent connections, edit the configuration files.";
    
    protected AddSshConnectionDialog(Shell parentShell) {
        super(parentShell);
        this.hint = HINT;
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
    }
   
}
