/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.utils;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import org.jpedal.objects.raw.FormObject;

public class FormUtils {
    public static AbstractButton[] sortGroupSmallestFirst(ButtonGroup buttonGroup) {
        int n = buttonGroup.getButtonCount();
        Component[] componentArray = new AbstractButton[n];
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        for (int i = 0; i < n; ++i) {
            if (!enumeration.hasMoreElements()) continue;
            componentArray[i] = enumeration.nextElement();
        }
        return (AbstractButton[])FormUtils.sortCompsAscending(componentArray);
    }

    private static Component[] sortCompsAscending(Component[] componentArray) {
        int n = componentArray.length;
        int n2 = n / 2;
        int n3 = n - 1;
        while (n2 > 0) {
            FormUtils.siftCompsAscending(componentArray, --n2, n3);
        }
        while (n3 > 0) {
            Component component = componentArray[0];
            componentArray[0] = componentArray[n3];
            componentArray[n3] = component;
            FormUtils.siftCompsAscending(componentArray, n2, --n3);
        }
        return componentArray;
    }

    private static void siftCompsAscending(Component[] componentArray, int n, int n2) {
        int n3 = n;
        Component component = componentArray[n3];
        int n4 = 2 * n + 1;
        if (n4 < n2 && FormUtils.shouldSwapControlAscending(componentArray[n4], componentArray[n4 + 1])) {
            ++n4;
        }
        while (n4 <= n2 && FormUtils.shouldSwapControlAscending(component, componentArray[n4])) {
            componentArray[n3] = componentArray[n4];
            n3 = n4;
            if ((n4 = 2 * n4 + 1) >= n2 || !FormUtils.shouldSwapControlAscending(componentArray[n4], componentArray[n4 + 1])) continue;
            ++n4;
        }
        componentArray[n3] = component;
    }

    private static boolean shouldSwapControlAscending(Component component, Component component2) {
        Rectangle rectangle = component.getBounds();
        Rectangle rectangle2 = component2.getBounds();
        return rectangle.width * rectangle.height < rectangle2.width * rectangle2.height;
    }

    public static String removeStateToCheck(String string, boolean bl) {
        int n;
        if (string != null && (n = string.indexOf("-(")) != -1) {
            string = bl ? string.substring(n + 2, string.length() - 1) : string.substring(0, n);
        }
        return string;
    }

    public static FormObject[] sortGroupLargestFirst(FormObject[] formObjectArray) {
        return FormUtils.sortCompsDesending(formObjectArray);
    }

    private static FormObject[] sortCompsDesending(FormObject[] formObjectArray) {
        int n = formObjectArray.length;
        int n2 = n / 2;
        int n3 = n - 1;
        while (n2 > 0) {
            FormUtils.siftCompsDesending(formObjectArray, --n2, n3);
        }
        while (n3 > 0) {
            FormObject formObject = formObjectArray[0];
            formObjectArray[0] = formObjectArray[n3];
            formObjectArray[n3] = formObject;
            FormUtils.siftCompsDesending(formObjectArray, n2, --n3);
        }
        return formObjectArray;
    }

    private static void siftCompsDesending(FormObject[] formObjectArray, int n, int n2) {
        int n3 = n;
        FormObject formObject = formObjectArray[n3];
        int n4 = 2 * n + 1;
        if (n4 < n2 && FormUtils.shouldSwapControlDesending(formObjectArray[n4], formObjectArray[n4 + 1])) {
            ++n4;
        }
        while (n4 <= n2 && FormUtils.shouldSwapControlDesending(formObject, formObjectArray[n4])) {
            formObjectArray[n3] = formObjectArray[n4];
            n3 = n4;
            if ((n4 = 2 * n4 + 1) >= n2 || !FormUtils.shouldSwapControlDesending(formObjectArray[n4], formObjectArray[n4 + 1])) continue;
            ++n4;
        }
        formObjectArray[n3] = formObject;
    }

    private static boolean shouldSwapControlDesending(FormObject formObject, FormObject formObject2) {
        if (formObject == null) {
            return formObject2 != null;
        }
        if (formObject2 == null) {
            return false;
        }
        Rectangle rectangle = formObject.getBoundingRectangle();
        Rectangle rectangle2 = formObject2.getBoundingRectangle();
        return rectangle.width * rectangle.height < rectangle2.width * rectangle2.height;
    }
}

