/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.widgets.IItemHolderAdapter;
import org.eclipse.swt.internal.widgets.SlimList;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public final class ItemHolder
implements IItemHolderAdapter {
    private final List items;
    private final Class type;
    static /* synthetic */ Class class$0;

    public static boolean isItemHolder(Widget widget) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IItemHolderAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return widget.getAdapter(clazz) != null;
    }

    public static Item[] getItems(Widget widget) {
        return ItemHolder.getItemHolder(widget).getItems();
    }

    public static void addItem(Widget widget, Item item) {
        ItemHolder.getItemHolder(widget).add(item);
    }

    public static void insertItem(Widget widget, Item item, int index) {
        ItemHolder.getItemHolder(widget).insert(item, index);
    }

    public static void removeItem(Widget widget, Item item) {
        ItemHolder.getItemHolder(widget).remove(item);
    }

    public ItemHolder(Class type) {
        this.type = type;
        this.items = new SlimList();
    }

    public int size() {
        return this.items.size();
    }

    public void add(Item item) {
        if (item == null) {
            SWT.error(4);
        }
        if (this.items.contains(item)) {
            String msg = "The item was already added.";
            throw new IllegalArgumentException(msg);
        }
        this.items.add(item);
    }

    public void insert(Item item, int index) {
        if (item == null) {
            SWT.error(4);
        }
        if (index < 0 || index > this.size()) {
            SWT.error(6);
        }
        if (this.items.contains(item)) {
            String msg = "The item was already added.";
            throw new IllegalArgumentException(msg);
        }
        this.items.add(index, item);
    }

    public void remove(Item item) {
        if (item == null) {
            SWT.error(4);
        }
        if (!this.items.contains(item)) {
            String msg = "The item was not added to this item holder.";
            throw new IllegalArgumentException(msg);
        }
        this.items.remove(item);
    }

    public Item[] getItems() {
        Object[] result = (Object[])Array.newInstance(this.type, this.items.size());
        this.items.toArray(result);
        return (Item[])result;
    }

    public Item getItem(int index) {
        if (index < 0 || index >= this.items.size()) {
            SWT.error(6);
        }
        return (Item)this.items.get(index);
    }

    public int indexOf(Item item) {
        return this.items.indexOf(item);
    }

    private static IItemHolderAdapter getItemHolder(Widget widget) {
        if (!ItemHolder.isItemHolder(widget)) {
            Object[] params = new Object[]{widget.getClass().getName()};
            String txt = "Widgets of type ''{0}'' do not contain items";
            String msg = MessageFormat.format(txt, params);
            throw new IllegalArgumentException(msg);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IItemHolderAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IItemHolderAdapter)widget.getAdapter(clazz);
    }
}

