/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.graphics;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.resources.IResourceManager;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.graphics.ImageDataCache;
import org.eclipse.swt.internal.graphics.InternalImage;

public class ImageDataFactory {
    private final ImageDataCache imageDataCache = new ImageDataCache();

    ImageDataFactory() {
    }

    ImageData findImageData(InternalImage internalImage) {
        ImageData result = this.imageDataCache.getImageData(internalImage);
        if (result == null && (result = ImageDataFactory.createImageData(internalImage)) != null) {
            this.imageDataCache.putImageData(internalImage, result);
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ImageData createImageData(InternalImage internalImage) {
        ImageData result = null;
        String imagePath = internalImage.getResourceName();
        try {
            IResourceManager resourceManager = RWT.getResourceManager();
            InputStream inputStream = resourceManager.getRegisteredContent(imagePath);
            if (inputStream == null) return result;
            try {
                result = new ImageData(inputStream);
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                inputStream.close();
                throw throwable;
            }
            {
                Object var5_9 = null;
                inputStream.close();
                return result;
            }
        }
        catch (IOException ioe) {
            String message = "Failed to close input stream";
            throw new RuntimeException(message, ioe);
        }
    }
}

