/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.smap;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.FileInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmapStratum {
    private String _stratumName;
    private List<FileInfo> _fileInfos;
    private int _actualfileId;

    public SmapStratum(String stratumName) {
        this._stratumName = stratumName;
        this._actualfileId = 0;
        this._fileInfos = new ArrayList<FileInfo>();
    }

    public String getStratumName() {
        return this._stratumName;
    }

    public void optimize() {
        for (FileInfo fileInfo : this._fileInfos) {
            if (!fileInfo.hasLineInfos()) continue;
            fileInfo.optimizeLineInfos();
        }
    }

    public FileInfo getOrCreateFileInfo(String fileName, String absoluteFileName) {
        FileInfo fileInfo = this.getFileInfo(fileName, absoluteFileName);
        if (fileInfo != null) {
            return fileInfo;
        }
        fileInfo = new FileInfo(this.getNextFileId(), fileName, absoluteFileName);
        this._fileInfos.add(fileInfo);
        return fileInfo;
    }

    private FileInfo getFileInfo(String fileName, String absoluteFileName) {
        if (this._fileInfos.isEmpty()) {
            return null;
        }
        for (FileInfo fileInfo : this._fileInfos) {
            if (fileInfo.getAbsoluteFileName() != null && fileInfo.getAbsoluteFileName().equals(absoluteFileName)) {
                return fileInfo;
            }
            if (!fileInfo.isEqualTo(fileName, absoluteFileName)) continue;
            return fileInfo;
        }
        return null;
    }

    private int getNextFileId() {
        ++this._actualfileId;
        return this._actualfileId;
    }

    public List<FileInfo> getFileInfos() {
        return this._fileInfos;
    }

    public String getSmapAsString() {
        FileInfo fileInfo;
        StringBuffer out = new StringBuffer();
        out.append("*S " + this._stratumName + "\n");
        out.append("*F\n");
        int idx = 0;
        while (idx < this._fileInfos.size()) {
            fileInfo = this._fileInfos.get(idx);
            if (fileInfo.getAbsoluteFileName() != null) {
                out.append("+ ");
            }
            out.append(String.valueOf(fileInfo.getFileId()) + " " + fileInfo.getFileName() + "\n");
            if (fileInfo.getAbsoluteFileName() != null) {
                out.append(String.valueOf(fileInfo.getAbsoluteFileName()) + "\n");
            }
            ++idx;
        }
        out.append("*L\n");
        idx = 0;
        while (idx < this._fileInfos.size()) {
            fileInfo = this._fileInfos.get(idx);
            out.append(fileInfo.getFileInfoDataAsString());
            ++idx;
        }
        return out.toString();
    }

    public String toString() {
        return this.getSmapAsString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SmapStratum)) {
            return false;
        }
        SmapStratum stratum = (SmapStratum)obj;
        if (!this.getStratumName().equals(stratum.getStratumName())) {
            return false;
        }
        if (this._fileInfos.size() != stratum.getFileInfos().size()) {
            return false;
        }
        return this._fileInfos.equals(stratum.getFileInfos());
    }

    public boolean hasFileInfos() {
        return this._fileInfos != null || this._fileInfos.size() > 0;
    }
}

