/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.MethodSpec;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.CallinCalloutScope;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.mappings.CallinImplementorDyn;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.FieldModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.RoleTypeCreator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TypeAnalyzer;

public class FieldAccessSpec
extends MethodSpec {
    public int calloutModifier;
    public FieldBinding resolvedField;
    private TypeBinding fieldType;

    public FieldAccessSpec(char[] name, TypeReference type, long nameSourcePositions, int calloutModifier) {
        super(name, nameSourcePositions);
        this.calloutModifier = calloutModifier;
        if (calloutModifier == 123 && type != null) {
            this.arguments = new Argument[]{new Argument(name, nameSourcePositions, type, 0)};
            this.returnType = TypeReference.baseTypeReference(6, 0);
            this.returnType.sourceStart = this.sourceStart;
            this.returnType.sourceEnd = this.sourceEnd;
        } else {
            this.returnType = type;
        }
    }

    public FieldAccessSpec(char[] name, TypeReference type, long nameSourcePositions, boolean isSetter) {
        this(name, type, nameSourcePositions, isSetter ? 123 : 122);
    }

    public void resolveFeature(ReferenceBinding baseType, BlockScope scope, boolean callinExpected, boolean isBaseSide, boolean allowEnclosing) {
        this.resolvedField = TypeAnalyzer.findField(baseType, this.selector, false, false);
        if (this.resolvedField == null) {
            this.resolvedField = new ProblemFieldBinding(baseType, this.selector, 1);
        }
        if (!this.resolvedField.isValidBinding()) {
            return;
        }
        this.fieldType = this.resolvedType();
        TypeBinding fieldLeafType = this.fieldType.leafComponentType();
        if (fieldLeafType instanceof ReferenceBinding && ((ReferenceBinding)fieldLeafType).isRole()) {
            ITeamAnchor newAnchor = null;
            if (baseType instanceof RoleTypeBinding) {
                RoleTypeBinding fieldRole;
                RoleTypeBinding baseRole = (RoleTypeBinding)baseType;
                newAnchor = fieldLeafType instanceof RoleTypeBinding ? ((fieldRole = (RoleTypeBinding)fieldLeafType).hasExplicitAnchor() ? fieldRole._teamAnchor.setPathPrefix(baseRole._teamAnchor) : baseRole._teamAnchor) : baseRole._teamAnchor;
            } else if (baseType.isTeam()) {
                SourceTypeBinding enclRole = scope.enclosingSourceType();
                newAnchor = TypeAnalyzer.findField(enclRole, IOTConstants._OT_BASE, false, false);
            }
            if (newAnchor != null && newAnchor.isValidBinding()) {
                this.fieldType = newAnchor.getRoleTypeBinding((ReferenceBinding)fieldLeafType, this.resolvedType().dimensions());
            }
        }
        if (!baseType.isRole() && this.resolvedField.canBeSeenBy(scope.enclosingReceiverType().baseclass(), this, scope)) {
            this.implementationStrategy = MethodSpec.ImplementationStrategy.DIRECT;
            this.parameters = !this.isSetter() ? Binding.NO_PARAMETERS : new TypeBinding[]{this.fieldType};
            return;
        }
        this.implementationStrategy = CallinImplementorDyn.DYNAMIC_WEAVING ? MethodSpec.ImplementationStrategy.DYN_ACCESS : MethodSpec.ImplementationStrategy.DECAPS_WRAPPER;
        char[] accessorSelector = this.getSelector();
        MethodBinding result = null;
        if (!this.resolvedField.isPrivate()) {
            result = baseType.getMethod(scope, accessorSelector);
        }
        if (result == null || !this.isMethodCompatible(result)) {
            RoleModel roleModel = scope.enclosingSourceType().roleModel;
            ReferenceBinding targetClass = roleModel.addAccessedBaseField(this.resolvedField, this.calloutModifier);
            result = this.createMethod(targetClass, accessorSelector);
            baseType.addMethod(result);
        }
        this.selector = accessorSelector;
        this.resolvedMethod = result;
        this.parameters = this.resolvedMethod.getSourceParameters();
    }

    private boolean isMethodCompatible(MethodBinding result) {
        TypeBinding methodType = null;
        switch (this.calloutModifier) {
            case 122: {
                methodType = result.returnType;
                break;
            }
            case 123: {
                int valueArgPosition;
                int n = valueArgPosition = this.resolvedField.isStatic() ? 0 : 1;
                if (result.parameters.length <= valueArgPosition) {
                    return false;
                }
                methodType = result.parameters[valueArgPosition];
            }
        }
        return this.fieldType.isCompatibleWith(methodType);
    }

    private char[] getSelector() {
        if (this.calloutModifier == 122) {
            return CharOperation.concat(IOTConstants.OT_GETFIELD, this.selector);
        }
        return CharOperation.concat(IOTConstants.OT_SETFIELD, this.selector);
    }

    private MethodBinding createMethod(ReferenceBinding baseType, char[] accessorSelector) {
        TypeBinding[] typeBindingArray;
        TypeBinding declaredFieldType;
        if (baseType instanceof RoleTypeBinding) {
            baseType = baseType.getRealClass();
        }
        if (this.calloutModifier == 122) {
            return FieldModel.getDecapsulatingFieldAccessor(baseType, this.resolvedField, true);
        }
        TypeBinding typeBinding = declaredFieldType = this.hasSignature ? this.parameters[0] : this.fieldType;
        if (this.resolvedField.isStatic()) {
            TypeBinding[] typeBindingArray2 = new TypeBinding[1];
            typeBindingArray = typeBindingArray2;
            typeBindingArray2[0] = declaredFieldType;
        } else {
            TypeBinding[] typeBindingArray3 = new TypeBinding[2];
            typeBindingArray3[0] = baseType;
            typeBindingArray = typeBindingArray3;
            typeBindingArray3[1] = declaredFieldType;
        }
        TypeBinding[] argTypes = typeBindingArray;
        return new MethodBinding(9, accessorSelector, TypeBinding.VOID, argTypes, Binding.NO_EXCEPTIONS, baseType);
    }

    public TypeBinding resolvedType() {
        if (this.fieldType != null) {
            return this.fieldType;
        }
        return this.resolvedField.type;
    }

    public TypeReference declaredType() {
        if (!this.hasSignature) {
            return null;
        }
        if (this.isSetter()) {
            return this.arguments[0].type;
        }
        return this.returnType;
    }

    public TypeBinding[] resolvedParameters() {
        if (this.resolvedMethod == null) {
            return this.parameters;
        }
        TypeBinding[] methodParams = super.resolvedParameters();
        if (this.resolvedField.isStatic()) {
            return methodParams;
        }
        TypeBinding[] result = new TypeBinding[methodParams.length - 1];
        System.arraycopy(methodParams, 1, result, 0, result.length);
        return result;
    }

    public ReferenceBinding getDeclaringClass() {
        if (this.resolvedField != null) {
            return this.resolvedField.declaringClass;
        }
        return null;
    }

    public void checkResolutionSuccess(ReferenceBinding type, CallinCalloutScope scope) {
        if (this.resolvedField == null) {
            this.resolvedField = new ProblemFieldBinding(type, this.selector, 1);
        } else if (this.resolvedField.isValidBinding()) {
            return;
        }
        scope.problemReporter().boundMethodProblem(this, type, true);
    }

    void checkDecapsulation(ReferenceBinding baseClass, Scope scope) {
        if (this.implementationStrategy != MethodSpec.ImplementationStrategy.DIRECT) {
            scope.problemReporter().decapsulation(this, baseClass, scope, this.isSetter());
        }
    }

    public boolean checkBaseReturnType(CallinCalloutScope scope, int bindDir) {
        TypeBinding baseReturnType;
        BaseTypeBinding accessorReturnType;
        if (this.calloutModifier == 122) {
            accessorReturnType = this.returnType != null ? this.returnType.resolvedType : null;
            baseReturnType = this.resolvedField.type;
        } else {
            accessorReturnType = TypeBinding.VOID;
            baseReturnType = this.resolvedMethod != null ? this.resolvedMethod.returnType : TypeBinding.VOID;
        }
        if (!TypeAnalyzer.isSameType(scope.enclosingSourceType(), accessorReturnType, baseReturnType)) {
            if (RoleTypeCreator.isCompatibleViaBaseAnchor(scope, baseReturnType, accessorReturnType, bindDir)) {
                return true;
            }
            scope.problemReporter().differentTypeInFieldSpec(this);
            return false;
        }
        return true;
    }

    public boolean checkParameterTypes(CallinCalloutScope scope, boolean isBase) {
        if (this.calloutModifier == 122) {
            return true;
        }
        int argumentPosition = 0;
        if (this.resolvedField != null && !this.resolvedField.isStatic()) {
            argumentPosition = 1;
        }
        TypeBinding accessorParamType = null;
        if (this.resolvedMethod != null) {
            accessorParamType = this.resolvedMethod.parameters[argumentPosition];
        } else if (this.hasSignature) {
            accessorParamType = this.arguments[0].type.resolvedType;
        } else {
            return true;
        }
        ReferenceBinding baseclass = scope.enclosingReceiverType().baseclass();
        if (baseclass != null && baseclass.isTeam() && accessorParamType.isRole()) {
            accessorParamType = TeamModel.strengthenRoleType(baseclass, accessorParamType);
        }
        if (!TypeAnalyzer.isSameType(scope.enclosingSourceType(), this.resolvedType(), accessorParamType)) {
            scope.problemReporter().differentTypeInFieldSpec(this);
            return false;
        }
        return true;
    }

    public char[] getFieldName() {
        return this.resolvedField.name;
    }

    public boolean isSetter() {
        return this.calloutModifier == 123;
    }

    public boolean isPrivate() {
        return this.resolvedField != null && this.resolvedField.isPrivate();
    }

    public boolean isStatic() {
        return this.resolvedField != null && this.resolvedField.isStatic();
    }

    public boolean isValid() {
        return this.resolvedField.isValidBinding();
    }

    public int problemId() {
        return this.resolvedField.problemId();
    }

    public char[] readableName() {
        return this.resolvedField.readableName();
    }

    public StringBuffer print(int indent, StringBuffer output) {
        FieldAccessSpec.printIndent(indent, output);
        output.append(this.calloutModifier == 122 ? "get " : "set ");
        if (this.hasSignature) {
            this.printReturnType(0, output);
        }
        output.append(new String(this.selector));
        return output;
    }

    public boolean isTypeAccess() {
        return this.resolvedField != null && this.resolvedField.isStatic();
    }

    public boolean canBeeSeenBy(ReferenceBinding receiverType, Scope scope) {
        if (this.resolvedField == null) {
            return false;
        }
        return this.resolvedField.canBeSeenBy(receiverType, this, scope);
    }

    public void createAccessAttribute(RoleModel roleModel) {
        roleModel.addAccessedBaseField(this.resolvedField, this.calloutModifier);
    }
}

