/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core;

import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.internal.core.CompilationUnitMapping;
import org.eclipse.objectteams.otdt.internal.core.OTType;
import org.eclipse.objectteams.otdt.internal.core.OTTypeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OTTypeMapping {
    private CompilationUnitMapping _data = new CompilationUnitMapping();

    public void put(IType type, IOTType otType) {
        if (type != null && otType != null) {
            IJavaElement key = this.getParent(type);
            if (this._data.contains(key)) {
                this._data.getOTTypes(key).add(otType);
            } else {
                this._data.add(key, new OTTypeList(otType));
            }
        }
    }

    public void remove(IType type) {
        if (type != null) {
            ICompilationUnit unit = type.getCompilationUnit();
            OTTypeList list = this._data.getOTTypes(unit);
            IOTType otType = this.get(type);
            if (otType != null) {
                IType[] innerTypes = otType.getInnerTypes();
                int idx = 0;
                while (idx < innerTypes.length) {
                    this.remove((IType)((IOTType)innerTypes[idx]).getCorrespondingJavaElement());
                    ++idx;
                }
                list.remove(type.getElementName());
            }
            if (list.getSize() == 0) {
                this._data.remove(unit);
            }
        }
    }

    public void removeChangedElement(IType elem) {
        IOTType otType = this.get(elem);
        if (otType != null && otType.getCorrespondingJavaElement() != elem) {
            this.remove(elem);
        }
    }

    public IOTType get(IType type) {
        OTTypeList elems;
        IJavaElement key;
        IOTType otElem = null;
        if (type != null && (key = this.getParent(type)) != null && (elems = this._data.getOTTypes(key)) != null) {
            otElem = elems.get(type.getFullyQualifiedName());
        }
        return otElem;
    }

    public List<OTType> getOTElements() {
        return this._data.getOTElements();
    }

    public boolean contains(IType type) {
        return this.get(type) != null;
    }

    private IJavaElement getParent(IType type) {
        ITypeRoot parent = type.isBinary() ? type.getClassFile() : type.getCompilationUnit();
        return parent;
    }
}

