/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.internal.core.OTType;

public class OTTypeList {
    private Map<String, IOTType> _data = new HashMap<String, IOTType>();

    public OTTypeList() {
    }

    public OTTypeList(IOTType otType) {
        this();
        this.add(otType);
    }

    public IOTType get(String fullyQualifiedName) {
        return this._data.get(fullyQualifiedName);
    }

    public void add(IOTType elem) {
        if (elem == null) {
            return;
        }
        this._data.put(elem.getFullyQualifiedName(), elem);
    }

    public void addAll(OTTypeList list) {
        if (list != null) {
            OTTypeIterator iter = list.getIterator();
            while (iter.hasNext()) {
                OTType cur = iter.getNext();
                this._data.put(cur.getFullyQualifiedName(), cur);
            }
        }
    }

    public void remove(String simpleName) {
        if (simpleName == null) {
            return;
        }
        this._data.remove(simpleName);
    }

    public int getSize() {
        return this._data.size();
    }

    public OTTypeIterator getIterator() {
        final Iterator<IOTType> _rawIter = this._data.values().iterator();
        return new OTTypeIterator(){

            public boolean hasNext() {
                return _rawIter.hasNext();
            }

            public OTType getNext() {
                return (OTType)_rawIter.next();
            }
        };
    }

    public static interface OTTypeIterator {
        public boolean hasNext();

        public OTType getNext();
    }
}

