/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.TypeAnchorReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Dependencies;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.OTClassScope;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ProblemAnchorBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.RoleTypeCreator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TypeAnalyzer;

public class ParameterizedSingleTypeReference
extends ArrayTypeReference {
    public TypeReference[] typeArguments;
    public TypeAnchorReference[] typeAnchors;

    public void setBaseclassDecapsulation(Expression.DecapsulationState state) {
        super.setBaseclassDecapsulation(state);
        if (this.typeArguments != null) {
            TypeReference[] typeReferenceArray = this.typeArguments;
            int n = this.typeArguments.length;
            int n2 = 0;
            while (n2 < n) {
                TypeReference argument = typeReferenceArray[n2];
                if (argument != null) {
                    argument.setBaseclassDecapsulation(state);
                }
                ++n2;
            }
        }
    }

    public ParameterizedSingleTypeReference(char[] name, TypeReference[] typeArguments, int dim, long pos) {
        super(name, dim, pos);
        this.originalSourceEnd = this.sourceEnd;
        this.typeArguments = typeArguments;
    }

    public void checkBounds(Scope scope) {
        if (this.resolvedType == null) {
            return;
        }
        if (this.resolvedType.leafComponentType() instanceof ParameterizedTypeBinding) {
            ParameterizedTypeBinding parameterizedType = (ParameterizedTypeBinding)this.resolvedType.leafComponentType();
            ReferenceBinding currentType = parameterizedType.genericType();
            TypeVariableBinding[] typeVariables = currentType.typeVariables();
            TypeBinding[] argTypes = parameterizedType.arguments;
            if (argTypes != null && typeVariables != null) {
                parameterizedType.boundCheck(scope, this.typeArguments);
            }
        }
    }

    public TypeReference copyDims(int dim) {
        return new ParameterizedSingleTypeReference(this.token, this.typeArguments, dim, ((long)this.sourceStart << 32) + (long)this.sourceEnd);
    }

    public char[][] getParameterizedTypeName() {
        if (this.typeArguments.length == 0) {
            return super.getParameterizedTypeName();
        }
        StringBuffer buffer = new StringBuffer(5);
        buffer.append(this.token).append('<');
        int i = 0;
        int length = this.typeArguments.length;
        while (i < length) {
            if (i > 0) {
                buffer.append(',');
            }
            buffer.append(CharOperation.concatWith(this.typeArguments[i].getParameterizedTypeName(), '.'));
            ++i;
        }
        buffer.append('>');
        int nameLength = buffer.length();
        char[] name = new char[nameLength];
        buffer.getChars(0, nameLength, name, 0);
        int dim = this.dimensions;
        if (dim > 0) {
            char[] dimChars = new char[dim * 2];
            int i2 = 0;
            while (i2 < dim) {
                int index = i2 * 2;
                dimChars[index] = 91;
                dimChars[index + 1] = 93;
                ++i2;
            }
            name = CharOperation.concat(name, dimChars);
        }
        return new char[][]{name};
    }

    protected TypeBinding getTypeBinding(Scope scope) {
        return null;
    }

    private TypeBinding internalResolveType(Scope scope, ReferenceBinding enclosingType, boolean checkBounds) {
        TypeBinding type;
        this.constant = Constant.NotAConstant;
        if ((this.bits & 0x40000) != 0 && this.resolvedType != null) {
            if (this.resolvedType.isValidBinding()) {
                return this.resolvedType;
            }
            switch (this.resolvedType.problemId()) {
                case 1: 
                case 2: 
                case 5: {
                    TypeBinding type2 = this.resolvedType.closestMatch();
                    return type2;
                }
            }
            return null;
        }
        this.bits |= 0x40000;
        int typeParamPos = 0;
        while (typeParamPos < this.typeArguments.length) {
            if (this.typeArguments[typeParamPos] instanceof TypeAnchorReference) {
                TypeAnchorReference typeAnchorReference = (TypeAnchorReference)this.typeArguments[typeParamPos];
                ITeamAnchor anchor = typeAnchorReference.resolveAnchor(scope);
                if (!ProblemAnchorBinding.checkAnchor(scope, typeAnchorReference, anchor, this.token)) {
                    return null;
                }
                ITeamAnchor[] iTeamAnchorArray = anchor.getBestNamePath();
                int n = iTeamAnchorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITeamAnchor seg = iTeamAnchorArray[n2];
                    if (!seg.isFinal()) {
                        scope.problemReporter().anchorPathNotFinal(typeAnchorReference, seg, this.token);
                    }
                    ++n2;
                }
                this.resolvedType = anchor.resolveRoleType(this.token, this.dimensions);
                if (this.resolvedType == null) {
                    ITeamAnchor[] declaredAnchors;
                    this.resolvedType = scope.getType(this.token);
                    if (this.resolvedType.isTypeVariable() && (declaredAnchors = ((TypeVariableBinding)this.resolvedType).anchors) != null && typeParamPos < declaredAnchors.length && declaredAnchors[typeParamPos].isValidBinding() && !declaredAnchors[typeParamPos].hasSameBestNameAs(anchor)) {
                        scope.problemReporter().rebindingTypeVariableAnchor(this, typeAnchorReference, declaredAnchors[typeParamPos]);
                    }
                    this.resolvedType = typeAnchorReference.createDependentTypeBinding(scope, this, typeParamPos);
                    if (this.resolvedType == null) {
                        this.resolvedType = new ProblemReferenceBinding(anchor, this.token, null, 1);
                        return null;
                    }
                }
                if (this.resolvedType != null && this.resolvedType.isValidBinding() && this.resolvedType instanceof ReferenceBinding && !this.checkParameterizedRoleVisibility(scope, anchor, (ReferenceBinding)this.resolvedType)) {
                    return null;
                }
                if (this.shouldAnalyzeRoleReference() && this.isIllegalQualifiedUseOfProtectedRole(scope)) {
                    return null;
                }
                int len = 0;
                if (this.typeAnchors != null) {
                    len = this.typeAnchors.length;
                    this.typeAnchors = new TypeAnchorReference[len + 1];
                    System.arraycopy(this.typeAnchors, 0, this.typeAnchors, 0, len);
                } else {
                    this.typeAnchors = new TypeAnchorReference[1];
                }
                this.typeAnchors[len] = typeAnchorReference;
                len = this.typeArguments.length - 1;
                this.typeArguments = new TypeReference[len];
                System.arraycopy(this.typeArguments, 1, this.typeArguments, 0, len);
                if (len == 0) {
                    return this.resolvedType;
                }
                scope.problemReporter().experimentalFeature(this, "Implementation for mixed type and value parameters is experimental.");
            }
            ++typeParamPos;
        }
        Scope importScope = null;
        if (this.getBaseclassDecapsulation().isAllowed()) {
            Scope currentScope = scope;
            while (currentScope != null) {
                if (currentScope instanceof OTClassScope && (importScope = ((OTClassScope)currentScope).getBaseImportScope()) != null) break;
                currentScope = currentScope.parent;
            }
        }
        if ((type = this.internalResolveLeafType(importScope, scope, enclosingType, checkBounds)) == null) {
            this.resolvedType = this.createArrayType(scope, this.resolvedType);
            return null;
        }
        type = this.createArrayType(scope, type);
        if (!this.resolvedType.isValidBinding()) {
            return type;
        }
        this.resolvedType = type;
        return this.resolvedType;
    }

    private TypeBinding internalResolveLeafType(Scope importScope, Scope scope, ReferenceBinding enclosingType, boolean checkBounds) {
        ReferenceBinding actualEnclosing;
        ReferenceBinding currentType;
        if (enclosingType == null) {
            if (importScope != null) {
                this.resolvedType = importScope.getType(this.token);
            }
            if (this.resolvedType == null || this.resolvedType.problemId() == 1) {
                this.resolvedType = scope.getType(this.token);
            }
            if (this.resolvedType.isValidBinding()) {
                currentType = (ReferenceBinding)this.resolvedType;
            } else {
                this.reportInvalidType(scope);
                switch (this.resolvedType.problemId()) {
                    case 1: 
                    case 2: 
                    case 5: {
                        TypeBinding type = this.resolvedType.closestMatch();
                        if (type instanceof ReferenceBinding) {
                            currentType = (ReferenceBinding)type;
                            break;
                        }
                    }
                    default: {
                        boolean isClassScope = scope.kind == 3;
                        int argLength = this.typeArguments.length;
                        int i = 0;
                        while (i < argLength) {
                            TypeReference typeArgument = this.typeArguments[i];
                            if (isClassScope) {
                                typeArgument.resolveType((ClassScope)scope);
                            } else {
                                typeArgument.resolveType((BlockScope)scope, checkBounds);
                            }
                            ++i;
                        }
                        return null;
                    }
                }
            }
            enclosingType = currentType.enclosingType();
            if (enclosingType != null) {
                enclosingType = currentType.isStatic() ? (ReferenceBinding)scope.environment().convertToRawType(enclosingType, false) : scope.environment().convertToParameterizedType(enclosingType);
                currentType = scope.environment().createParameterizedType((ReferenceBinding)currentType.erasure(), null, enclosingType);
            }
        } else {
            ReferenceBinding currentEnclosing;
            currentType = scope.getMemberType(this.token, enclosingType);
            this.resolvedType = currentType;
            if (!this.resolvedType.isValidBinding()) {
                scope.problemReporter().invalidEnclosingType(this, currentType, enclosingType);
                return null;
            }
            if (this.isTypeUseDeprecated(currentType, scope)) {
                scope.problemReporter().deprecatedType(currentType, this);
            }
            if ((currentEnclosing = currentType.enclosingType()) != null && currentEnclosing.erasure() != enclosingType.erasure()) {
                enclosingType = currentEnclosing;
            }
        }
        boolean isClassScope = scope.kind == 3;
        TypeReference keep = null;
        if (isClassScope) {
            keep = ((ClassScope)scope).superTypeReference;
            ((ClassScope)scope).superTypeReference = null;
        }
        int argLength = this.typeArguments.length;
        TypeBinding[] argTypes = new TypeBinding[argLength];
        boolean argHasError = false;
        ReferenceBinding currentOriginal = (ReferenceBinding)currentType.original();
        int i = 0;
        while (i < argLength) {
            TypeReference typeArgument = this.typeArguments[i];
            if (typeArgument instanceof TypeAnchorReference) {
                scope.problemReporter().incompleteDependentTypesImplementation(typeArgument, "type value parameter must be in 1st position");
                argHasError = true;
            } else {
                TypeBinding argType;
                TypeBinding typeBinding = argType = isClassScope ? typeArgument.resolveTypeArgument((ClassScope)scope, currentOriginal, i) : typeArgument.resolveTypeArgument((BlockScope)scope, currentOriginal, i);
                if (argType == null) {
                    argHasError = true;
                } else {
                    argTypes[i] = argType = RoleTypeCreator.maybeWrapUnqualifiedRoleType(scope, argType, (ASTNode)typeArgument);
                }
            }
            ++i;
        }
        if (argHasError) {
            return null;
        }
        if (isClassScope) {
            ((ClassScope)scope).superTypeReference = keep;
            if (((ClassScope)scope).detectHierarchyCycle(currentOriginal, this)) {
                return null;
            }
        }
        boolean isDiamond = (this.bits & 0x80000) != 0;
        TypeVariableBinding[] typeVariables = currentOriginal.typeVariables();
        if (typeVariables == Binding.NO_TYPE_VARIABLES) {
            boolean isCompliant15;
            boolean bl = isCompliant15 = scope.compilerOptions().originalSourceLevel >= 0x310000L;
            if ((currentOriginal.tagBits & 0x80L) == 0L && isCompliant15) {
                this.resolvedType = currentType;
                scope.problemReporter().nonGenericTypeCannotBeParameterized(0, this, currentType, argTypes);
                return null;
            }
            if (!isCompliant15) {
                if (!this.resolvedType.isValidBinding()) {
                    return currentType;
                }
                this.resolvedType = currentType;
                return this.resolvedType;
            }
        } else if (argLength != typeVariables.length) {
            if (!isDiamond) {
                scope.problemReporter().incorrectArityForParameterizedType(this, currentType, argTypes);
                return null;
            }
        } else if (!currentType.isStatic() && (actualEnclosing = currentType.enclosingType()) != null && actualEnclosing.isRawType()) {
            scope.problemReporter().rawMemberTypeCannotBeParameterized(this, scope.environment().createRawType(currentOriginal, actualEnclosing), argTypes);
            return null;
        }
        if (!isDiamond && argLength == 0) {
            return this.resolvedType;
        }
        ParameterizedTypeBinding parameterizedType = scope.environment().createParameterizedType(currentOriginal, argTypes, enclosingType);
        if (!isDiamond) {
            if (checkBounds) {
                parameterizedType.boundCheck(scope, this.typeArguments);
            } else {
                scope.deferBoundCheck(this);
            }
        }
        if (this.isTypeUseDeprecated(parameterizedType, scope)) {
            this.reportDeprecatedType(parameterizedType, scope);
        }
        if (!this.resolvedType.isValidBinding()) {
            return parameterizedType;
        }
        this.resolvedType = parameterizedType;
        return this.resolvedType;
    }

    private TypeBinding createArrayType(Scope scope, TypeBinding type) {
        if (this.dimensions > 0) {
            if (this.dimensions > 255) {
                scope.problemReporter().tooManyDimensions(this);
            }
            return scope.createArrayType(type, this.dimensions);
        }
        return type;
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        int i;
        int i2;
        output.append(this.token);
        output.append("<");
        int length = this.typeArguments.length;
        if (this.typeAnchors != null) {
            int anchorLen = this.typeAnchors.length;
            i2 = 0;
            while (i2 < anchorLen) {
                this.typeAnchors[i2].print(0, output);
                if (i2 + 1 < anchorLen || length > 0) {
                    output.append(", ");
                }
                ++i2;
            }
        }
        if (length > 0) {
            int max = length - 1;
            i2 = 0;
            while (i2 < max) {
                this.typeArguments[i2].print(0, output);
                output.append(", ");
                ++i2;
            }
            this.typeArguments[max].print(0, output);
        }
        output.append(">");
        if ((this.bits & 0x4000) != 0) {
            i = 0;
            while (i < this.dimensions - 1) {
                output.append("[]");
                ++i;
            }
            output.append("...");
        } else {
            i = 0;
            while (i < this.dimensions) {
                output.append("[]");
                ++i;
            }
        }
        return output;
    }

    public TypeBinding resolveType(BlockScope scope, boolean checkBounds) {
        return this.internalResolveType(scope, null, checkBounds);
    }

    public TypeBinding resolveType(ClassScope scope) {
        return this.internalResolveType(scope, null, false);
    }

    public TypeBinding resolveTypeEnclosing(BlockScope scope, ReferenceBinding enclosingType) {
        return this.internalResolveType(scope, enclosingType, true);
    }

    public TypeBinding checkResolveUsingBaseImportScope(Scope scope) {
        if (this.getBaseclassDecapsulation().isAllowed() || scope.isBaseGuard()) {
            TypeBinding problem = this.resolvedType;
            this.resolvedType = null;
            Scope currentScope = scope;
            while (currentScope != null) {
                Scope baseImportScope;
                if (currentScope instanceof OTClassScope && (baseImportScope = ((OTClassScope)currentScope).getBaseImportScope()) != null) {
                    this.resolvedType = this.getTypeBinding(baseImportScope);
                    if (this.resolvedType != null && this.resolvedType.isValidBinding()) {
                        this.resolvedType = this.checkResolvedType(this.resolvedType, baseImportScope, false);
                        return this.resolvedType;
                    }
                }
                currentScope = currentScope.parent;
            }
            this.resolvedType = problem;
        }
        return null;
    }

    boolean checkParameterizedRoleVisibility(Scope scope, ITeamAnchor anchor, ReferenceBinding type) {
        if (!type.isPublic()) {
            Dependencies.ensureBindingState(type, 6);
            if (TypeAnalyzer.isConfined(type)) {
                scope.problemReporter().decapsulatingConfined(this, (ReferenceBinding)this.resolvedType);
                this.setBaseclassDecapsulation(Expression.DecapsulationState.CONFINED);
                this.resolvedType = new ProblemReferenceBinding(anchor, this.token, type, 2);
                return false;
            }
            if (RoleTypeBinding.isRoleWithExplicitAnchor(type)) {
                switch (this.getBaseclassDecapsulation()) {
                    case ALLOWED: {
                        scope.problemReporter().decapsulation(this, type);
                        this.setBaseclassDecapsulation(Expression.DecapsulationState.REPORTED);
                    }
                    case REPORTED: {
                        return true;
                    }
                    case NONE: {
                        this.resolvedType = new ProblemReferenceBinding(anchor, this.token, type, 2);
                        scope.problemReporter().qualifiedProtectedRole(this, type);
                        return false;
                    }
                }
            } else if (!type.canBeSeenBy(scope)) {
                this.resolvedType = new ProblemReferenceBinding(anchor, this.token, type, 2);
                this.reportInvalidType(scope);
                return false;
            }
        }
        return true;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            int i = 0;
            int max = this.typeArguments.length;
            while (i < max) {
                this.typeArguments[i].traverse(visitor, scope);
                ++i;
            }
        }
        visitor.endVisit(this, scope);
    }

    public void traverse(ASTVisitor visitor, ClassScope scope) {
        if (visitor.visit(this, scope)) {
            int i = 0;
            int max = this.typeArguments.length;
            while (i < max) {
                this.typeArguments[i].traverse(visitor, scope);
                ++i;
            }
        }
        visitor.endVisit(this, scope);
    }

    public static char[][] getTypeAnchor(TypeReference typeReference) {
        if (typeReference instanceof ParameterizedSingleTypeReference) {
            TypeReference first;
            ParameterizedSingleTypeReference type = (ParameterizedSingleTypeReference)typeReference;
            if (type.resolvedType != null) {
                TypeAnchorReference[] anchors = type.typeAnchors;
                if (anchors != null && anchors.length == 1) {
                    return ParameterizedSingleTypeReference.beautifyTypeAnchor(anchors[0].getTypeName());
                }
            } else if (type.typeArguments != null && type.typeArguments.length > 0 && (first = type.typeArguments[0]) instanceof TypeAnchorReference) {
                char[][] anchorName = first.getTypeName();
                anchorName[0] = CharOperation.subarray(anchorName[0], 1, -1);
                return ParameterizedSingleTypeReference.beautifyTypeAnchor(anchorName);
            }
        }
        return null;
    }

    private static char[][] beautifyTypeAnchor(char[][] orig) {
        int len = orig.length;
        if (!CharOperation.equals(orig[len - 1], IOTConstants._OT_BASE)) {
            return orig;
        }
        char[][] result = new char[len][];
        System.arraycopy(orig, 0, result, 0, len - 1);
        result[len - 1] = IOTConstants.BASE;
        return result;
    }
}

